/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.ObjectDetailsConfig;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditObjectPropertyDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(EditObjectPropertyDialog.class);
    private LabeledText name;
    private LabeledText displayName;
    private Combo type;
    private ObjectDetailsConfig.ObjectProperty property;

    public EditObjectPropertyDialog(Shell parentShell, ObjectDetailsConfig.ObjectProperty property) {
        super(parentShell);
        this.property = property;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Edit Property"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.name.setLayoutData((Object)gd);
        this.name.setText(this.property.name);
        this.displayName = new LabeledText(dialogArea, 0);
        this.displayName.setLabel(this.i18n.tr("Display name"));
        this.displayName.getTextControl().setTextLimit(63);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.displayName.setLayoutData((Object)gd);
        this.displayName.setText(this.property.displayName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)this.i18n.tr("Data type"), (Object)gd);
        this.type.add("String");
        this.type.add("Integer");
        this.type.add("Number");
        this.type.select(this.property.type);
        return dialogArea;
    }

    protected void okPressed() {
        this.property.name = this.name.getText().trim();
        if (this.property.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid property name!"));
            return;
        }
        this.property.displayName = this.displayName.getText().trim();
        this.property.type = this.type.getSelectionIndex();
        super.okPressed();
    }

    public ObjectDetailsConfig.ObjectProperty getProperty() {
        return this.property;
    }
}

