/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.xml.XMLTools;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.PerfTabGraphSettings;
import org.netxms.ui.eclipse.perfview.widgets.YAxisRangeEditor;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.ExtendedColorSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class PerfTab
extends AbstractDCIPropertyPage {
    private DataCollectionItem dci;
    private PerfTabGraphSettings settings;
    private Button checkShow;
    private Button checkLogScale;
    private Button checkStacked;
    private Button checkShowLegendAlways;
    private Button checkExtendedLegend;
    private Button checkUseMultipliers;
    private Button checkInvertValues;
    private Button checkTranslucent;
    private LabeledText title;
    private LabeledText name;
    private ExtendedColorSelector color;
    private Combo type;
    private Spinner orderNumber;
    private Button checkShowThresholds;
    private LabeledText groupName;
    private Spinner timeRange;
    private Combo timeUnits;
    private YAxisRangeEditor yAxisRange;

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        try {
            this.settings = (PerfTabGraphSettings)XMLTools.createFromXml(PerfTabGraphSettings.class, (String)this.dci.getPerfTabSettings());
        }
        catch (Exception e) {
            this.settings = new PerfTabGraphSettings();
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        this.checkShow = new Button(dialogArea, 32);
        Messages.get();
        this.checkShow.setText(Messages.PerfTab_ShowOnPerfTab);
        this.checkShow.setSelection(this.settings.isEnabled());
        GridData gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkShow.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        Messages.get();
        this.title.setLabel(Messages.PerfTab_Title);
        this.title.setText(this.settings.getTitle());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.title.setLayoutData((Object)gd);
        this.groupName = new LabeledText(dialogArea, 0);
        this.groupName.setLabel("Group");
        this.groupName.setText(this.settings.getGroupName());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.groupName.setLayoutData((Object)gd);
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.PerfTab_NameInLegend);
        this.name.setText(this.settings.getName());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.name.setLayoutData((Object)gd);
        Group timeGroup = new Group(dialogArea, 0);
        Messages.get();
        timeGroup.setText(Messages.PerfTab_TeimePeriod);
        GridLayout timeGroupLayout = new GridLayout();
        timeGroupLayout.makeColumnsEqualWidth = true;
        timeGroupLayout.numColumns = 2;
        timeGroup.setLayout((Layout)timeGroupLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        timeGroup.setLayoutData((Object)gd);
        Messages.get();
        this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeGroup, (int)2048, (String)Messages.PerfTab_TimeInterval, (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
        this.timeRange.setSelection(this.settings.getTimeRange());
        Messages.get();
        this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeGroup, (int)8, (String)Messages.PerfTab_TimeUnits, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.timeUnits.add(Messages.PerfTab_Minutes);
        Messages.get();
        this.timeUnits.add(Messages.PerfTab_Hours);
        Messages.get();
        this.timeUnits.add(Messages.PerfTab_Days);
        this.timeUnits.select(this.settings.getTimeUnits());
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.PerfTab_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 3;
        gd.verticalAlignment = 4;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowThresholds = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowThresholds.setText(Messages.PerfTab_ShowThresholds);
        this.checkShowThresholds.setSelection(this.settings.isShowThresholds());
        this.checkLogScale = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkLogScale.setText(Messages.PerfTab_LogarithmicScale);
        this.checkLogScale.setSelection(this.settings.isLogScaleEnabled());
        this.checkStacked = new Button((Composite)optionsGroup, 32);
        this.checkStacked.setText("&Stacked");
        this.checkStacked.setSelection(this.settings.isStacked());
        this.checkShowLegendAlways = new Button((Composite)optionsGroup, 32);
        this.checkShowLegendAlways.setText("Always show &legend");
        this.checkShowLegendAlways.setSelection(this.settings.isShowLegendAlways());
        this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
        this.checkExtendedLegend.setText("&Extended legend");
        this.checkExtendedLegend.setSelection(this.settings.isExtendedLegend());
        this.checkUseMultipliers = new Button((Composite)optionsGroup, 32);
        this.checkUseMultipliers.setText("Use &multipliers");
        this.checkUseMultipliers.setSelection(this.settings.isUseMultipliers());
        this.checkInvertValues = new Button((Composite)optionsGroup, 32);
        this.checkInvertValues.setText("&Inverted values");
        this.checkInvertValues.setSelection(this.settings.isInvertedValues());
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText("&Translucent");
        this.checkTranslucent.setSelection(this.settings.isTranslucent());
        this.color = new ExtendedColorSelector(dialogArea);
        Messages.get();
        this.color.setLabels(Messages.PerfTab_Color, "Automatic", "Custom");
        this.color.setColorValue(this.settings.isAutomaticColor() ? null : ColorConverter.rgbFromInt((int)this.settings.getColorAsInt()));
        gd = new GridData();
        gd.verticalSpan = 2;
        gd.verticalAlignment = 4;
        this.color.setLayoutData((Object)gd);
        Messages.get();
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.PerfTab_Type, (Object)new GridData(4, 128, false, false));
        Messages.get();
        this.type.add(Messages.PerfTab_Line);
        Messages.get();
        this.type.add(Messages.PerfTab_Area);
        this.type.select(this.settings.getType());
        Messages.get();
        this.orderNumber = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.PerfTab_Order, (int)0, (int)65535, (Object)new GridData(4, 128, false, false));
        this.orderNumber.setSelection(this.settings.getOrder());
        this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.yAxisRange.setLayoutData(gd);
        this.yAxisRange.setSelection(this.settings.isAutoScale(), this.settings.modifyYBase(), this.settings.getMinYScaleValue(), this.settings.getMaxYScaleValue());
        return dialogArea;
    }

    private void applyChanges(boolean isApply) {
        this.settings.setEnabled(this.checkShow.getSelection());
        this.settings.setLogScaleEnabled(this.checkLogScale.getSelection());
        this.settings.setTitle(this.title.getText());
        this.settings.setName(this.name.getText());
        this.settings.setType(this.type.getSelectionIndex());
        this.settings.setOrder(this.orderNumber.getSelection());
        this.settings.setGroupName(this.groupName.getText().trim());
        this.settings.setShowThresholds(this.checkShowThresholds.getSelection());
        this.settings.setStacked(this.checkStacked.getSelection());
        this.settings.setShowLegendAlways(this.checkShowLegendAlways.getSelection());
        this.settings.setExtendedLegend(this.checkExtendedLegend.getSelection());
        this.settings.setUseMultipliers(this.checkUseMultipliers.getSelection());
        this.settings.setInvertedValues(this.checkInvertValues.getSelection());
        this.settings.setTranslucent(this.checkTranslucent.getSelection());
        this.settings.setAutoScale(this.yAxisRange.isAuto());
        this.settings.setMinYScaleValue(this.yAxisRange.getMinY());
        this.settings.setMaxYScaleValue(this.yAxisRange.getMaxY());
        this.settings.setModifyYBase(this.yAxisRange.modifyYBase());
        this.settings.setTimeRange(this.timeRange.getSelection());
        this.settings.setTimeUnits(this.timeUnits.getSelectionIndex());
        RGB rgb = this.color.getColorValue();
        if (rgb != null) {
            this.settings.setAutomaticColor(false);
            this.settings.setColor(ColorConverter.rgbToInt((RGB)rgb));
        } else {
            this.settings.setAutomaticColor(true);
        }
        try {
            this.dci.setPerfTabSettings(this.settings.createXml());
        }
        catch (Exception e) {
            this.dci.setPerfTabSettings(null);
        }
        this.editor.modify();
    }

    protected void performApply() {
        if (this.yAxisRange.validate(true)) {
            this.applyChanges(true);
        }
    }

    public boolean performOk() {
        if (!this.yAxisRange.validate(true)) {
            return false;
        }
        this.applyChanges(false);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        PerfTabGraphSettings defaults = new PerfTabGraphSettings();
        this.checkShow.setSelection(defaults.isEnabled());
        this.title.setText(defaults.getTitle());
        this.color.setColorValue(ColorConverter.rgbFromInt((int)defaults.getColorAsInt()));
        this.groupName.setText("");
        this.orderNumber.setSelection(100);
    }
}

