/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.HardwareComponent;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.HardwareComponentCategory;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;

public class HardwareComponentLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Map<HardwareComponentCategory, String> categoryNames = new HashMap<HardwareComponentCategory, String>();

    public HardwareComponentLabelProvider() {
        this.categoryNames.put(HardwareComponentCategory.BASEBOARD, "Baseboard");
        this.categoryNames.put(HardwareComponentCategory.BATTERY, "Battery");
        this.categoryNames.put(HardwareComponentCategory.MEMORY_DEVICE, "Memory device");
        this.categoryNames.put(HardwareComponentCategory.NETWORK_ADAPTER, "Network adapter");
        this.categoryNames.put(HardwareComponentCategory.OTHER, "Other");
        this.categoryNames.put(HardwareComponentCategory.PROCESSOR, "Processor");
        this.categoryNames.put(HardwareComponentCategory.STORAGE_DEVICE, "Storage device");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        HardwareComponent c = (HardwareComponent)element;
        switch (columnIndex) {
            case 5: {
                switch (c.getCategory()) {
                    case BATTERY: {
                        return String.valueOf(Long.toString(c.getCapacity())) + " mWh";
                    }
                    case MEMORY_DEVICE: 
                    case STORAGE_DEVICE: {
                        return new DataFormatter("%{u,m}s", DataType.UINT64, MeasurementUnit.BYTES_IEC).format(Long.toString(c.getCapacity()), RegionalSettings.TIME_FORMATTER);
                    }
                    case NETWORK_ADAPTER: {
                        return new DataFormatter("%{u,m}s", DataType.UINT64, MeasurementUnit.BPS_METRIC).format(Long.toString(c.getCapacity()), RegionalSettings.TIME_FORMATTER);
                    }
                    case PROCESSOR: {
                        return new DataFormatter("%{u,m}s", DataType.UINT64, MeasurementUnit.HZ).format(Long.toString(c.getCapacity() * 1000000L), RegionalSettings.TIME_FORMATTER);
                    }
                }
                return "";
            }
            case 0: {
                return this.categoryNames.get(c.getCategory());
            }
            case 9: {
                return c.getDescription();
            }
            case 1: {
                return Integer.toString(c.getIndex());
            }
            case 8: {
                return c.getLocation();
            }
            case 4: {
                return c.getModel();
            }
            case 6: {
                return c.getPartNumber();
            }
            case 7: {
                return c.getSerialNumber();
            }
            case 2: {
                return c.getType();
            }
            case 3: {
                return c.getVendor();
            }
        }
        return null;
    }
}

