/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.dialogs.CreateNewToolDialog;
import org.netxms.ui.eclipse.objecttools.propertypages.AccessControl;
import org.netxms.ui.eclipse.objecttools.propertypages.Columns;
import org.netxms.ui.eclipse.objecttools.propertypages.Filter;
import org.netxms.ui.eclipse.objecttools.propertypages.General;
import org.netxms.ui.eclipse.objecttools.propertypages.InputFields;
import org.netxms.ui.eclipse.objecttools.views.helpers.ObjectToolsComparator;
import org.netxms.ui.eclipse.objecttools.views.helpers.ObjectToolsFilter;
import org.netxms.ui.eclipse.objecttools.views.helpers.ObjectToolsLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectToolsEditor
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.ObjectToolsEditor";
    private static final String TABLE_CONFIG_PREFIX = "ObjectToolsEditor";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private Map<Long, ObjectTool> tools = new HashMap<Long, ObjectTool>();
    private SortableTableViewer viewer;
    private NXCSession session;
    private Action actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionClone;
    private Action actionDelete;
    private Action actionDisable;
    private Action actionEnable;
    private Action actionShowFilter;
    private Composite content;
    private FilterText filterText;
    private ObjectToolsFilter filter;
    private boolean initShowFilter = true;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.initShowFilter = ObjectToolsEditor.getBooleanSetting("ObjectTools.showFilter", this.initShowFilter);
        this.session = ConsoleSharedData.getSession();
    }

    private static boolean getBooleanSetting(String name, boolean defval) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(name) == null) {
            return defval;
        }
        return settings.getBoolean(name);
    }

    public void createPartControl(Composite parent) {
        try {
            Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.content = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        this.content.setLayout((Layout)formLayout);
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectToolsEditor.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ObjectToolsEditor.this.enableFilter(false);
                ObjectToolsEditor.this.actionShowFilter.setChecked(ObjectToolsEditor.this.initShowFilter);
            }
        });
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.ObjectToolsEditor_ColId;
        Messages.get();
        stringArray[1] = Messages.ObjectToolsEditor_ColName;
        Messages.get();
        stringArray[2] = Messages.ObjectToolsEditor_ColType;
        Messages.get();
        stringArray[3] = Messages.ObjectToolsEditor_ColDescr;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{90, 200, 100, 200};
        this.viewer = new SortableTableViewer(this.content, columnNames, columnWidths, 1, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectToolsLabelProvider());
        this.filter = new ObjectToolsFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.setComparator((ViewerComparator)new ObjectToolsComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ObjectToolsEditor.this.actionEdit.setEnabled(selection.size() == 1);
                    ObjectToolsEditor.this.actionClone.setEnabled(selection.size() == 1);
                    ObjectToolsEditor.this.actionDelete.setEnabled(selection.size() > 0);
                    ObjectToolsEditor.this.actionDisable.setEnabled(ObjectToolsEditor.containsEnabled(selection));
                    ObjectToolsEditor.this.actionEnable.setEnabled(ObjectToolsEditor.containsDisabled(selection));
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectToolsEditor.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ObjectToolsEditor.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ObjectToolsEditor.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createActions();
        this.contributeToActionBars();
        this.createContextMenu();
        this.activateContext();
        this.session.addListener((SessionListener)this);
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refresh();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objecttools.context.ObjectTools");
        }
    }

    public void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private static boolean containsDisabled(IStructuredSelection selection) {
        for (Object o : selection.toList()) {
            if (((ObjectTool)o).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static boolean containsEnabled(IStructuredSelection selection) {
        for (Object o : selection.toList()) {
            if (!((ObjectTool)o).isEnabled()) continue;
            return true;
        }
        return false;
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                ObjectToolsEditor.this.enableFilter(!ObjectToolsEditor.this.initShowFilter);
                ObjectToolsEditor.this.actionShowFilter.setChecked(ObjectToolsEditor.this.initShowFilter);
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.showFilter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectToolsEditor.this.refresh();
            }
        };
        Messages.get();
        this.actionNew = new Action(Messages.ObjectToolsEditor_New){

            public void run() {
                ObjectToolsEditor.this.createTool();
            }
        };
        this.actionNew.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEdit = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer){

            public void run() {
                IStructuredSelection selection = ObjectToolsEditor.this.viewer.getStructuredSelection();
                if (selection.size() != 1) {
                    return;
                }
                if (Platform.getAdapterManager().getAdapter(selection.getFirstElement(), ObjectToolDetails.class) == null) {
                    return;
                }
                ObjectToolDetails objectToolDetails = (ObjectToolDetails)Platform.getAdapterManager().getAdapter(selection.getFirstElement(), ObjectToolDetails.class);
                if (ObjectToolsEditor.this.showObjectToolPropertyPages(objectToolDetails)) {
                    ObjectToolsEditor.this.saveObjectTool(objectToolDetails);
                }
            }
        };
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
        Messages.get();
        this.actionDelete = new Action(Messages.ObjectToolsEditor_Delete){

            public void run() {
                ObjectToolsEditor.this.deleteTools();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
        Messages.get();
        this.actionDisable = new Action(Messages.ObjectToolsEditor_Disable){

            public void run() {
                ObjectToolsEditor.this.enableTools(false);
            }
        };
        Messages.get();
        this.actionEnable = new Action(Messages.ObjectToolsEditor_Enable){

            public void run() {
                ObjectToolsEditor.this.enableTools(true);
            }
        };
        Messages.get();
        this.actionClone = new Action(Messages.ObjectToolsEditor_Clone){

            public void run() {
                ObjectToolsEditor.this.cloneTool();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectToolsEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionClone);
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (ObjectToolsEditor.containsEnabled(selection)) {
            mgr.add((IAction)this.actionDisable);
        }
        if (ObjectToolsEditor.containsDisabled(selection)) {
            mgr.add((IAction)this.actionEnable);
        }
        mgr.add((IAction)this.actionDelete);
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.ObjectToolsEditor_JobGetConfig, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List tl = ObjectToolsEditor.this.session.getObjectTools();
                this.runInUIThread(() -> {
                    ObjectToolsEditor.this.tools.clear();
                    for (ObjectTool t : tl) {
                        ObjectToolsEditor.this.tools.put(t.getId(), t);
                    }
                    ObjectToolsEditor.this.viewer.setInput((Object)ObjectToolsEditor.this.tools.values().toArray());
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsEditor_JobGetConfigError;
            }
        }.start();
    }

    private void createTool() {
        final CreateNewToolDialog dlg = new CreateNewToolDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ObjectToolsEditor_JobNewId, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools"){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long toolId = ObjectToolsEditor.this.session.generateObjectToolId();
                    ObjectToolDetails details = new ObjectToolDetails(toolId, dlg.getType(), dlg.getName());
                    ObjectToolsEditor.this.session.modifyObjectTool(details);
                    this.runInUIThread(() -> {
                        if (ObjectToolsEditor.this.showObjectToolPropertyPages(details) && details.isModified()) {
                            ObjectToolsEditor.this.saveObjectTool(details);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ObjectToolsEditor_JobNewIdError;
                }
            }.start();
        }
    }

    private void deleteTools() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.ObjectToolsEditor_Confirmation, (String)Messages.ObjectToolsEditor_DeleteConfirmation)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.ObjectToolsEditor_JobDelete, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsEditor_JobDeleteError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    ObjectToolsEditor.this.session.deleteObjectTool(((ObjectTool)objects[i]).getId());
                    ++i;
                }
            }
        }.start();
    }

    private void saveObjectTool(final ObjectToolDetails details) {
        Messages.get();
        new ConsoleJob(Messages.ObjectToolsEditor_JobSave, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ObjectToolsEditor.this.session.modifyObjectTool(details);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsEditor_JobSaveError;
            }
        }.schedule();
    }

    private void enableTools(final boolean enable) {
        String string;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        final ArrayList<Long> toolIdList = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            if (((ObjectTool)o).isEnabled() == enable) continue;
            toolIdList.add(((ObjectTool)o).getId());
        }
        if (enable) {
            Messages.get();
            string = Messages.ObjectToolsEditor_EnableObjTool;
        } else {
            Messages.get();
            string = Messages.ObjectToolsEditor_DisableObjTool;
        }
        new ConsoleJob(string, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Iterator iterator = toolIdList.iterator();
                while (iterator.hasNext()) {
                    long toolId = (Long)iterator.next();
                    ObjectToolsEditor.this.session.enableObjectTool(toolId, enable);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsEditor_ErrorDisablingObjectTools;
            }
        }.start();
    }

    private void cloneTool() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final ObjectTool currentTool = (ObjectTool)selection.getFirstElement();
        final InputDialog dlg = new InputDialog(this.getSite().getShell(), "Clone Object Tool", "Enter name for cloned object tool", String.valueOf(currentTool.getName()) + "2", new IInputValidator(){

            public String isValid(String newText) {
                return newText.isBlank() ? "Name should not be blank" : null;
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.ObjectToolsEditor_CloneObjectTool, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long toolId = ObjectToolsEditor.this.session.generateObjectToolId();
                ObjectToolDetails details = ObjectToolsEditor.this.session.getObjectToolDetails(currentTool.getId());
                details.setId(toolId);
                details.setName(dlg.getValue());
                ObjectToolsEditor.this.session.modifyObjectTool(details);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsEditor_CloneError;
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1009: {
                this.getSite().getShell().getDisplay().asyncExec(() -> this.refresh());
                break;
            }
            case 1015: {
                this.getSite().getShell().getDisplay().asyncExec(() -> {
                    this.tools.remove(n.getSubCode());
                    this.viewer.setInput((Object)this.tools.values().toArray());
                });
            }
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ObjectTools.showFilter", this.initShowFilter);
        super.dispose();
    }

    private boolean showObjectToolPropertyPages(final ObjectToolDetails objectTool) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General(objectTool)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("access_control", (IPreferencePage)new AccessControl(objectTool)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("filter", (IPreferencePage)new Filter(objectTool)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("input_fields", (IPreferencePage)new InputFields(objectTool)));
        if (objectTool.getToolType() == 3 || objectTool.getToolType() == 2) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("columns", (IPreferencePage)new Columns(objectTool)));
        }
        PreferenceDialog dlg = new PreferenceDialog(this.getViewSite().getShell(), pm){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Properties for " + objectTool.getCommandDisplayName());
            }
        };
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }
}

