/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.GeoMapConfig;
import org.netxms.ui.eclipse.osm.widgets.ObjectGeoLocationViewer;

public class GeoMapElement
extends ElementWidget {
    private ObjectGeoLocationViewer mapWidget;
    private GeoMapConfig config;

    public GeoMapElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = (GeoMapConfig)new Gson().fromJson(element.getData(), GeoMapConfig.class);
        }
        catch (Exception e) {
            Activator.logError((String)"Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new GeoMapConfig();
        }
        this.processCommonSettings(this.config);
        this.mapWidget = new ObjectGeoLocationViewer(this.getContentArea(), 0);
        this.mapWidget.setViewPart(viewPart);
        this.mapWidget.setRootObjectId(this.getEffectiveObjectId(this.config.getRootObjectId()));
        this.mapWidget.showMap(this.config.getLatitude(), this.config.getLongitude(), this.config.getZoom());
    }

    @Override
    protected int getPreferredHeight() {
        return 600;
    }
}

