/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DciContainerConfiguration;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.elements.NetworkMapElement;

public class NetworkMapDCIContainer
extends NetworkMapElement {
    private int backgroundColor;
    private int textColor;
    private int borderColor;
    private boolean borderRequired;
    private MapDataSource[] dciArray;

    protected NetworkMapDCIContainer(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String json = msg.getFieldAsString(baseId + 10L);
        try {
            DciContainerConfiguration config = (DciContainerConfiguration)new Gson().fromJson(json, DciContainerConfiguration.class);
            this.backgroundColor = config.getBackgroundColor();
            this.textColor = config.getTextColor();
            this.borderColor = config.getBorderColor();
            this.borderRequired = config.isBorderRequired();
            this.dciArray = config.getDciList();
        }
        catch (Exception e) {
            this.backgroundColor = 0xFFFFFF;
            this.textColor = 0x202020;
            this.borderColor = 0x202020;
            this.borderRequired = false;
            this.dciArray = null;
        }
    }

    public NetworkMapDCIContainer(long id) {
        super(id);
        this.type = 3;
        this.dciArray = null;
        this.backgroundColor = 0xFFFFFF;
        this.textColor = 0x202020;
        this.borderColor = 0x202020;
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        DciContainerConfiguration config = new DciContainerConfiguration();
        config.setDciList(this.dciArray);
        config.setBackgroundColor(this.backgroundColor);
        config.setTextColor(this.textColor);
        config.setBorderColor(this.borderColor);
        config.setBorderRequired(this.borderRequired);
        msg.setFieldJson(baseId + 10L, (Object)config);
    }

    public boolean hasDciData() {
        return this.dciArray != null && this.dciArray.length > 0;
    }

    public MapDataSource[] getObjectDCIArray() {
        return this.dciArray;
    }

    public void setObjectDCIArray(MapDataSource[] dciArray) {
        this.dciArray = dciArray;
    }

    public List<MapDataSource> getDciAsList() {
        ArrayList<MapDataSource> dciList = new ArrayList<MapDataSource>();
        if (this.hasDciData()) {
            MapDataSource[] mapDataSourceArray = this.dciArray;
            int n = this.dciArray.length;
            int n2 = 0;
            while (n2 < n) {
                MapDataSource dci = mapDataSourceArray[n2];
                dciList.add(dci);
                ++n2;
            }
        }
        return dciList;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isBorderRequired() {
        return this.borderRequired;
    }

    public void setBorderRequired(boolean borderRequired) {
        this.borderRequired = borderRequired;
    }
}

