/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.InetAddressEx;
import org.netxms.client.InetAddressListElement;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectSelectionFilterFactory;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.modules.objects.widgets.ZoneSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class AddressListElementEditDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(AddressListElementEditDialog.class);
    private Button radioSubnet;
    private Button radioRange;
    private LabeledText textAddr1;
    private LabeledText textAddr2;
    private LabeledText comments;
    private ZoneSelector zoneSelector;
    private ObjectSelector proxySelector;
    private InetAddressListElement element;
    private boolean enableProxySelection;
    private boolean warnOnWideMask;

    public AddressListElementEditDialog(Shell parentShell, boolean enableProxySelection, boolean warnOnWideMask, InetAddressListElement element) {
        super(parentShell);
        this.enableProxySelection = enableProxySelection;
        this.warnOnWideMask = warnOnWideMask;
        this.element = element;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.element != null ? this.i18n.tr("Edit Address List Element") : this.i18n.tr("Add Address List Element"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.radioSubnet = new Button(dialogArea, 16);
        this.radioSubnet.setText(this.i18n.tr("&Subnet"));
        this.radioSubnet.setSelection(true);
        this.radioSubnet.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.radioRange = new Button(dialogArea, 16);
        this.radioRange.setText(this.i18n.tr("Address &range"));
        this.radioRange.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.textAddr1 = new LabeledText(dialogArea, 0);
        this.textAddr1.setLabel(this.i18n.tr("Network address"));
        this.textAddr1.setText("0.0.0.0");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textAddr1.setLayoutData((Object)gd);
        this.textAddr2 = new LabeledText(dialogArea, 0);
        this.textAddr2.setLabel(this.i18n.tr("Network mask"));
        this.textAddr2.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textAddr2.setLayoutData((Object)gd);
        if (this.enableProxySelection) {
            if (Registry.getSession().isZoningEnabled()) {
                this.zoneSelector = new ZoneSelector(dialogArea, 0, true);
                this.zoneSelector.setLabel(this.i18n.tr("Zone"));
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.zoneSelector.setLayoutData((Object)gd);
            }
            this.proxySelector = new ObjectSelector(dialogArea, 0, true);
            this.proxySelector.setLabel(this.i18n.tr("Proxy node"));
            this.proxySelector.setEmptySelectionName(this.i18n.tr("Zone proxy"));
            this.proxySelector.setClassFilter(ObjectSelectionFilterFactory.getInstance().createNodeSelectionFilter(false));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.proxySelector.setLayoutData((Object)gd);
        }
        this.comments = new LabeledText(dialogArea, 0);
        this.comments.setLabel(this.i18n.tr("Comments"));
        this.comments.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comments.setLayoutData((Object)gd);
        if (this.element != null) {
            this.radioSubnet.setSelection(this.element.isSubnet());
            this.radioRange.setSelection(!this.element.isSubnet());
            if (!this.element.isSubnet()) {
                this.textAddr1.setLabel(this.i18n.tr("Start address"));
                this.textAddr2.setLabel(this.i18n.tr("End address"));
            }
            this.textAddr1.setText(this.element.getBaseAddress().getHostAddress());
            this.textAddr2.setText(this.element.isSubnet() ? Integer.toString(this.element.getMaskBits()) : this.element.getEndAddress().getHostAddress());
            if (this.enableProxySelection) {
                if (Registry.getSession().isZoningEnabled()) {
                    this.zoneSelector.setZoneUIN(this.element.getZoneUIN());
                }
                this.proxySelector.setObjectId(this.element.getProxyId());
            }
            this.comments.setText(this.element.getComment());
        }
        return dialogArea;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void okPressed() {
        try {
            long proxyId;
            int zoneUIN;
            int n = zoneUIN = this.zoneSelector != null ? this.zoneSelector.getZoneUIN() : 0;
            if (zoneUIN == -1) {
                zoneUIN = 0;
            }
            long l = proxyId = this.proxySelector != null ? this.proxySelector.getObjectId() : 0L;
            if (this.radioSubnet.getSelection()) {
                int maskBits;
                InetAddress baseAddress = InetAddress.getByName(this.textAddr1.getText().trim());
                String maskText = this.textAddr2.getText().trim();
                if (baseAddress instanceof Inet4Address && maskText.indexOf(46) > 0) {
                    InetAddress maskAddress = InetAddress.getByName(maskText);
                    if (!(maskAddress instanceof Inet4Address)) throw new NumberFormatException("Invalid network mask");
                    maskBits = InetAddressEx.bitsInMask((InetAddress)maskAddress);
                } else {
                    maskBits = Integer.parseInt(maskText);
                }
                if (maskBits < 0 || baseAddress instanceof Inet4Address && maskBits > 32 || baseAddress instanceof Inet6Address && maskBits > 128) {
                    throw new NumberFormatException("Invalid network mask");
                }
                if (this.warnOnWideMask && maskBits < 16 && !MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You have specified network mask that includes more than 65536 IP addresses. Do you really intend it?"))) {
                    return;
                }
                if (this.element == null) {
                    this.element = new InetAddressListElement(baseAddress, maskBits, zoneUIN, proxyId, this.comments.getText());
                } else {
                    this.element.update(baseAddress, maskBits, zoneUIN, proxyId, this.comments.getText());
                }
            } else {
                byte[] bytes2;
                byte[] bytes1;
                InetAddress addr1 = InetAddress.getByName(this.textAddr1.getText().trim());
                InetAddress addr2 = InetAddress.getByName(this.textAddr2.getText().trim());
                if (this.warnOnWideMask && addr1 instanceof Inet4Address && addr2 instanceof Inet4Address && ((bytes1 = addr1.getAddress())[0] != (bytes2 = addr2.getAddress())[0] || bytes1[1] != bytes2[1]) && !MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You have specified address range that includes more than 65536 IP addresses. Do you really intend it?"))) {
                    return;
                }
                if (this.element == null) {
                    this.element = new InetAddressListElement(addr1, addr2, zoneUIN, proxyId, this.comments.getText());
                } else {
                    this.element.update(addr1, addr2, zoneUIN, proxyId, this.comments.getText());
                }
            }
        }
        catch (NumberFormatException | UnknownHostException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid IP address/mask"));
            return;
        }
        super.okPressed();
    }

    public InetAddressListElement getElement() {
        return this.element;
    }
}

