/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class SummaryTablesCache {
    private static final Logger logger = LoggerFactory.getLogger(SummaryTablesCache.class);
    private Map<Integer, DciSummaryTableDescriptor> tables = new HashMap();
    private NXCSession session;

    public static void attachSession(Display display, NXCSession session) {
        SummaryTablesCache instance = new SummaryTablesCache(session);
        Registry.setSingleton((Display)display, SummaryTablesCache.class, (Object)instance);
    }

    public static SummaryTablesCache getInstance() {
        return (SummaryTablesCache)Registry.getSingleton(SummaryTablesCache.class);
    }

    private SummaryTablesCache(NXCSession session) {
        this.session = session;
        this.reload();
        session.addListener((SessionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            List list = this.session.listDciSummaryTables();
            Map map = this.tables;
            synchronized (map) {
                this.tables.clear();
                for (DciSummaryTableDescriptor d : list) {
                    this.tables.put(d.getId(), d);
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception in SummaryTablesCache.reload()", (Throwable)e);
        }
    }

    private void onTableChange(int tableId) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTableDelete(int tableId) {
        Map map = this.tables;
        synchronized (map) {
            this.tables.remove(tableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DciSummaryTableDescriptor[] getTables() {
        Map map = this.tables;
        synchronized (map) {
            return this.tables.values().toArray(new DciSummaryTableDescriptor[this.tables.values().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(boolean menuOnly) {
        Map map = this.tables;
        synchronized (map) {
            if (menuOnly) {
                for (DciSummaryTableDescriptor d : this.tables.values()) {
                    if (d.getMenuPath().isEmpty()) continue;
                    return false;
                }
                return true;
            }
            return this.tables.isEmpty();
        }
    }

    public static void queryTable(long baseObjectId, long contextId, int tableId, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        I18n i18n = LocalizationHelper.getI18n(SummaryTablesCache.class);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

