/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.configs.MapLinkDataSource;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectDciDialog;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.dialogs.DataSourceEditDlg;
import org.netxms.ui.eclipse.networkmaps.propertypages.helper.DciListLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkEditor;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class LinkDataSources
extends PropertyPage {
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_METRIC = 2;
    private DciListLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private LinkEditor link;
    private List<MapLinkDataSource> dciList = null;

    protected Control createContents(Composite parent) {
        this.link = (LinkEditor)this.getElement().getAdapter(LinkEditor.class);
        this.dciList = this.link.getDciList();
        Composite dialogArea = new Composite(parent, 0);
        this.labelProvider = new DciListLabelProvider(this.dciList);
        this.labelProvider.resolveDciNames(this.dciList);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.LinkDataSources_ColPos;
        Messages.get();
        stringArray[1] = Messages.LinkDataSources_ColNode;
        Messages.get();
        stringArray[2] = Messages.LinkDataSources_ColParameter;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{40, 130, 200};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.setInput((Object)this.dciList.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.LinkDataSources_Up);
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LinkDataSources.this.moveUp();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.LinkDataSources_Down);
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LinkDataSources.this.moveDown();
            }
        });
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        Messages.get();
        this.addButton.setText(Messages.LinkDataSources_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LinkDataSources.this.addItem();
            }
        });
        this.editButton = new Button(rightButtons, 8);
        Messages.get();
        this.editButton.setText(Messages.LinkDataSources_Modify);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LinkDataSources.this.editItem();
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.LinkDataSources_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                LinkDataSources.this.deleteItems();
            }
        });
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LinkDataSources.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LinkDataSources.this.viewer.getSelection();
                LinkDataSources.this.editButton.setEnabled(selection.size() == 1);
                LinkDataSources.this.deleteButton.setEnabled(selection.size() > 0);
                LinkDataSources.this.upButton.setEnabled(selection.size() == 1);
                LinkDataSources.this.downButton.setEnabled(selection.size() == 1);
            }
        });
        return dialogArea;
    }

    private void addItem() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), 0L);
        if (dlg.open() == 0) {
            List selection = dlg.getSelection();
            ArrayList<MapLinkDataSource> select = new ArrayList<MapLinkDataSource>();
            for (DciValue item : selection) {
                MapLinkDataSource dci = new MapLinkDataSource(item);
                select.add(dci);
                this.labelProvider.addCacheEntry(dci.getNodeId(), dci.getDciId(), "");
                this.dciList.add(dci);
            }
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(select));
        }
    }

    private void editItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        MapLinkDataSource dci = (MapLinkDataSource)selection.getFirstElement();
        if (dci == null) {
            return;
        }
        DataSourceEditDlg dlg = new DataSourceEditDlg(this.getShell(), (MapDataSource)dci);
        if (dlg.open() == 0) {
            this.viewer.update((Object)dci, null);
        }
    }

    private void deleteItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.dciList.remove(o);
        }
        this.viewer.setInput((Object)this.dciList.toArray());
    }

    private void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.dciList, index - 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) < this.dciList.size() - 1 && index >= 0) {
            Collections.swap(this.dciList, index + 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private boolean applyChanges(boolean isApply) {
        this.link.setDciList(this.dciList);
        this.link.setModified();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

