/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.helpers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="item")
public class AppMenuItem {
    @Element(required=false)
    private String name;
    @Element(required=false)
    private String description;
    @Element(required=false)
    private String icon;
    @Element(required=false)
    private String command;
    @ElementList(required=false)
    private List<AppMenuItem> items = null;
    private AppMenuItem parent = null;

    public AppMenuItem(String name, String description, String command, AppMenuItem parent) {
        this.name = name;
        this.description = description;
        this.command = command;
        this.parent = parent;
    }

    public AppMenuItem(String name, String description, AppMenuItem parent) {
        this.name = name;
        this.description = description;
        this.command = null;
        this.parent = parent;
        this.items = new ArrayList<AppMenuItem>(0);
    }

    public AppMenuItem() {
        this.name = null;
        this.description = null;
        this.command = null;
        this.parent = null;
    }

    public AppMenuItem(boolean subMenu) {
        this.name = null;
        this.description = null;
        this.command = null;
        this.parent = null;
        if (subMenu) {
            this.items = new ArrayList<AppMenuItem>(0);
        }
    }

    public boolean isSubMenu() {
        return this.items != null;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean hasChildren() {
        return this.items != null && !this.items.isEmpty();
    }

    public AppMenuItem[] getChildren() {
        return this.items != null ? this.items.toArray(new AppMenuItem[this.items.size()]) : null;
    }

    public AppMenuItem getParent() {
        return this.parent;
    }

    public void setIcon(byte[] bs) {
        try {
            this.icon = new String(Base64.encodeBase64((byte[])bs, (boolean)false), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            this.icon = "";
        }
    }

    public void updateParents(AppMenuItem parent) {
        this.parent = parent;
        if (this.items != null) {
            for (AppMenuItem child : this.items) {
                child.updateParents(this);
            }
        }
    }

    public boolean delete() {
        if (this.parent != null) {
            this.parent.removeSubItem(this);
            this.clearChildren();
            return true;
        }
        return false;
    }

    private void clearChildren() {
        if (this.items == null) {
            return;
        }
        for (AppMenuItem obj : this.items) {
            obj.clearChildren();
        }
        this.items = null;
    }

    private void removeSubItem(AppMenuItem item) {
        if (this.items != null) {
            this.items.remove(item);
        }
    }

    public void addSubItem(AppMenuItem item) {
        if (this.items != null) {
            this.items.add(item);
        }
    }

    public Image getIcon() {
        if (this.icon == null) {
            return null;
        }
        try {
            byte[] tmp = Base64.decodeBase64((byte[])this.icon.getBytes("ISO-8859-1"));
            ByteArrayInputStream input = new ByteArrayInputStream(tmp);
            ImageDescriptor d = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)input));
            return d.createImage();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

