/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.shared;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.netxms.client.LibraryImage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;

public class ImageProvider {
    private static ImageProvider instance = null;
    private final NXCSession session;
    private final Display display;
    private final Image missingImage;
    private final Map<UUID, Image> imageCache = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Image> objectIconCache = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, LibraryImage> libraryIndex = Collections.synchronizedMap(new HashMap());
    private final Set<ImageUpdateListener> updateListeners = new HashSet<ImageUpdateListener>();

    public static void createInstance(Display display, NXCSession session) {
        if (instance == null) {
            instance = new ImageProvider(display, session);
        }
    }

    public static ImageProvider getInstance() {
        return instance;
    }

    private ImageProvider(Display display, NXCSession session) {
        this.display = display;
        this.session = session;
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.netxms.ui.eclipse.imagelibrary", (String)"icons/missing.png");
        this.missingImage = imageDescriptor.createImage((Device)display);
    }

    public void addUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ImageUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    private void notifyListeners(UUID guid) {
        for (ImageUpdateListener listener : this.updateListeners) {
            listener.imageUpdated(guid);
        }
    }

    public void syncMetaData() throws IOException, NXCException {
        List imageLibrary = this.session.getImageLibrary();
        this.libraryIndex.clear();
        this.clearCache();
        for (LibraryImage libraryImage : imageLibrary) {
            this.libraryIndex.put(libraryImage.getGuid(), libraryImage);
        }
    }

    private void clearCache() {
        for (Image image : this.imageCache.values()) {
            if (image == this.missingImage) continue;
            image.dispose();
        }
        this.imageCache.clear();
        for (Image image : this.objectIconCache.values()) {
            if (image == this.missingImage || image.isDisposed()) continue;
            image.dispose();
        }
        this.objectIconCache.clear();
    }

    public Image getImage(UUID guid) {
        Image image;
        if (guid == null) {
            return this.missingImage;
        }
        if (this.imageCache.containsKey(guid)) {
            image = this.imageCache.get(guid);
        } else {
            image = this.missingImage;
            this.loadImageFromServer(guid);
        }
        return image;
    }

    public Image getObjectIcon(UUID guid) {
        Image image;
        if (guid == null) {
            return this.missingImage;
        }
        if (this.objectIconCache.containsKey(guid)) {
            image = this.objectIconCache.get(guid);
        } else if (this.imageCache.containsKey(guid)) {
            image = this.imageCache.get(guid);
            ImageData imageData = image.getImageData();
            int zoom = DPIUtil.getDeviceZoom();
            int requiredSize = 16 * zoom / 100;
            if (imageData.width == requiredSize && imageData.height == requiredSize) {
                this.objectIconCache.put(guid, image);
            } else {
                if (imageData.width != imageData.height) {
                    int size = Math.min(imageData.width, imageData.height);
                    Image trimmedImage = new Image((Device)this.display, size, size);
                    GC gc = new GC((Drawable)trimmedImage);
                    gc.drawImage(image, 0, 0);
                    gc.dispose();
                    imageData = trimmedImage.getImageData();
                    trimmedImage.dispose();
                }
                image = new Image((Device)this.display, (ImageDataProvider)new DPIUtil.AutoScaleImageDataProvider((Device)this.display, imageData, imageData.width * 100 / requiredSize));
                this.objectIconCache.put(guid, image);
            }
        } else {
            image = this.missingImage;
            this.loadImageFromServer(guid);
        }
        return image;
    }

    private void loadImageFromServer(final UUID guid) {
        this.imageCache.put(guid, this.missingImage);
        if (!this.libraryIndex.containsKey(guid)) {
            return;
        }
        ConsoleJob job = new ConsoleJob("Loading image from server", null, "org.netxms.ui.eclipse.imagelibrary"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    LibraryImage libraryImage = ImageProvider.this.session.getImage(guid);
                    final ByteArrayInputStream stream = new ByteArrayInputStream(libraryImage.getBinaryData());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                (this).ImageProvider.this.imageCache.put(guid, new Image((Device)(this).ImageProvider.this.display, (InputStream)stream));
                                ImageProvider.this.notifyListeners(guid);
                            }
                            catch (SWTException e) {
                                Activator.logError("Cannot decode image", (Exception)((Object)e));
                                (this).ImageProvider.this.imageCache.put(guid, (this).ImageProvider.this.missingImage);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Activator.logError("Cannot retrive image from server", e);
                }
            }

            protected String getErrorMessage() {
                return "Cannot load image from server";
            }
        };
        job.setUser(false);
        job.start();
    }

    public LibraryImage getLibraryImageObject(UUID guid) {
        return this.libraryIndex.get(guid);
    }

    public List<LibraryImage> getImageLibrary() {
        return new ArrayList<LibraryImage>(this.libraryIndex.values());
    }

    public void updateImage(final UUID guid) {
        Image image = this.imageCache.remove(guid);
        if (image != null && image != this.missingImage) {
            image.dispose();
        }
        if ((image = this.objectIconCache.remove(guid)) != null && image != this.missingImage && !image.isDisposed()) {
            image.dispose();
        }
        ConsoleJob job = new ConsoleJob("Update library image", null, "org.netxms.ui.eclipse.imagelibrary", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                LibraryImage imageHandle = ImageProvider.this.session.getImage(guid);
                ImageProvider.this.libraryIndex.put(guid, imageHandle);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ImageProvider.this.notifyListeners(guid);
                    }
                });
            }

            protected IStatus createFailureStatus(Exception e) {
                return Status.OK_STATUS;
            }

            protected String getErrorMessage() {
                return null;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void deleteImage(final UUID guid) {
        Image image = this.imageCache.remove(guid);
        if (image != null && image != this.missingImage) {
            image.dispose();
        }
        if ((image = this.objectIconCache.remove(guid)) != null && image != this.missingImage && !image.isDisposed()) {
            image.dispose();
        }
        this.libraryIndex.remove(guid);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ImageProvider.this.notifyListeners(guid);
            }
        });
    }
}

