/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.Severity;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.widgets.MessageBar;

public class CompositeWithMessageBar
extends Composite
implements MessageBar {
    private Composite messageBar;
    private CLabel messageBarLabel;
    private Label closeButton;
    private Composite content;

    public CompositeWithMessageBar(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.messageBar = new Composite((Composite)this, 0);
        this.messageBar.setBackground(ThemeEngine.getBackgroundColor("MessageBar"));
        this.messageBar.setForeground(ThemeEngine.getForegroundColor("MessageBar"));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.messageBar.setLayout((Layout)layout);
        this.messageBarLabel = new CLabel(this.messageBar, 0);
        this.messageBarLabel.setBackground(this.messageBar.getBackground());
        this.messageBarLabel.setForeground(this.messageBar.getForeground());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.messageBarLabel.setLayoutData((Object)gd);
        this.messageBar.setVisible(false);
        this.closeButton = new Label(this.messageBar, 0);
        this.closeButton.setBackground(this.messageBar.getBackground());
        this.closeButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.closeButton.setImage(SharedIcons.IMG_CLOSE);
        Messages.get();
        this.closeButton.setToolTipText(Messages.CompositeWithMessageBar_HideMessage);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.closeButton.setLayoutData((Object)gd);
        this.closeButton.addMouseListener(new MouseListener(){
            private boolean doAction = false;

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.doAction = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && this.doAction) {
                    CompositeWithMessageBar.this.hideMessage();
                }
            }
        });
        Label separator = new Label(this.messageBar, 258);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        separator.setLayoutData((Object)gd);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.messageBar.setLayoutData((Object)fd);
        this.content = this.createContent(this);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.content.setLayoutData((Object)fd);
    }

    protected Composite createContent(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new FillLayout());
        return c;
    }

    public void setContent(Composite c) {
        if (this.content != null) {
            this.content.dispose();
        }
        this.content = c;
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.content.setLayoutData((Object)fd);
    }

    @Override
    public void showMessage(int severity, String text) {
        if (this.isDisposed()) {
            return;
        }
        switch (severity) {
            case 1: {
                this.messageBarLabel.setImage(StatusDisplayInfo.getStatusImage(Severity.WARNING));
                break;
            }
            case 2: {
                this.messageBarLabel.setImage(StatusDisplayInfo.getStatusImage(Severity.CRITICAL));
                break;
            }
            default: {
                this.messageBarLabel.setImage(SharedIcons.IMG_INFORMATION);
            }
        }
        this.messageBarLabel.setText(text);
        this.messageBar.setVisible(true);
        ((FormData)this.content.getLayoutData()).top = new FormAttachment((Control)this.messageBar, 0, 1024);
        this.layout(true, true);
    }

    @Override
    public void hideMessage() {
        if (this.isDisposed()) {
            return;
        }
        this.messageBar.setVisible(false);
        ((FormData)this.content.getLayoutData()).top = new FormAttachment(0, 0);
        this.layout(true, true);
    }

    public Composite getContent() {
        return this.content;
    }
}

