/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.localization.LocalizationHelper;

public class ComponentTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] className = new String[]{null, LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Other"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Unknown"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Chassis"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Backplane"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Container"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Power Supply"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Fan"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Sensor"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Module"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Port"), LocalizationHelper.getI18n(ComponentTreeLabelProvider.class).tr("Stack")};
    private Map<Integer, Interface> interfaces = new HashMap();

    public void setNode(AbstractNode node) {
        this.interfaces.clear();
        if (node != null) {
            for (AbstractObject i : node.getAllChildren(3)) {
                if (((Interface)i).getIfIndex() <= 0) continue;
                this.interfaces.put(((Interface)i).getIfIndex(), (Interface)i);
            }
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        PhysicalComponent c = (PhysicalComponent)element;
        switch (columnIndex) {
            case 1: {
                try {
                    return className[c.getPhyClass()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return className[2];
                }
            }
            case 2: {
                return c.getDescription();
            }
            case 7: {
                return this.getInterfaceName(c);
            }
            case 4: {
                return c.getFirmware();
            }
            case 3: {
                return c.getModel();
            }
            case 0: {
                return c.getDisplayName();
            }
            case 5: {
                return c.getSerialNumber();
            }
            case 6: {
                return c.getVendor();
            }
        }
        return null;
    }

    private String getInterfaceName(PhysicalComponent c) {
        int ifIndex = c.getIfIndex();
        if (ifIndex <= 0) {
            return "";
        }
        Interface iface = (Interface)this.interfaces.get(ifIndex);
        return iface != null ? iface.getObjectName() : null;
    }
}

