/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.widgets.LocalFileSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class StartClientToServerFileUploadDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(StartClientToServerFileUploadDialog.class);
    private LocalFileSelector fileSelector;
    private LabeledText textRemoteFile;
    private List<File> localFiles = new ArrayList();
    private String remoteFileName;

    public StartClientToServerFileUploadDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Upload File"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.fileSelector = new LocalFileSelector(dialogArea, 0, false, 4098);
        this.fileSelector.setLabel(this.i18n.tr("Local file"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.fileSelector.setLayoutData((Object)gd);
        this.fileSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.textRemoteFile = new LabeledText(dialogArea, 0);
        this.textRemoteFile.setLabel(this.i18n.tr("Remote file name"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textRemoteFile.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        if (this.localFiles.size() <= 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select file for upload"));
            return;
        }
        this.remoteFileName = this.textRemoteFile.getText().trim();
        if (this.remoteFileName.isEmpty() && this.localFiles.size() == 1) {
            this.remoteFileName = ((File)this.localFiles.get(0)).getName();
        }
        super.okPressed();
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    public List<File> getLocalFiles() {
        return this.localFiles;
    }
}

