/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.StyledText;
import org.netxms.nxmc.base.widgets.helpers.LineStyler;
import org.netxms.nxmc.resources.ThemeEngine;

public class JsonViewer
extends Composite {
    private StyledText textControl;
    private Color colorBuiltin = ThemeEngine.getForegroundColor((String)"JSON.Builtin");
    private Color colorKey = ThemeEngine.getForegroundColor((String)"JSON.Key");
    private Color colorNumber = ThemeEngine.getForegroundColor((String)"JSON.Number");
    private Color colorString = ThemeEngine.getForegroundColor((String)"JSON.String");

    public JsonViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.textControl = new StyledText((Composite)this, 778);
        this.textControl.setFont(JFaceResources.getTextFont());
        this.textControl.setLineStyler((LineStyler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setContent(String jsonText, boolean prettify) {
        if (prettify) {
            if (!((String)(jsonText = ((String)jsonText).trim())).startsWith("{") && !((String)jsonText).startsWith("[")) {
                jsonText = "{" + (String)jsonText + "}";
            }
            Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
            JsonElement json = (JsonElement)gson.fromJson((String)jsonText, JsonElement.class);
            jsonText = gson.toJson(json);
        }
        this.textControl.setText((String)jsonText);
    }
}

