/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusIndicatorConfig;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class StatusIndicator
extends PropertyPage {
    private StatusIndicatorConfig config;
    private TitleConfigurator title;
    private LabeledSpinner numColumns;
    private Combo shape;
    private Combo labelType;
    private Button checkFullColors;

    protected Control createContents(Composite parent) {
        this.config = (StatusIndicatorConfig)this.getElement().getAdapter(StatusIndicatorConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        this.title.setLayoutData(gd);
        this.shape = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Shape", (Object)"WidgetHelper::default_layout_data");
        this.shape.add("Circle");
        this.shape.add("Rectangle");
        this.shape.add("Rounded rectangle");
        this.shape.select(this.config.getShape());
        this.labelType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Label", (Object)"WidgetHelper::default_layout_data");
        this.labelType.add("None");
        this.labelType.add("Inside");
        this.labelType.add("Outside");
        this.labelType.select(this.config.getLabelType());
        this.numColumns = new LabeledSpinner(dialogArea, 0);
        this.numColumns.setLabel("Columns");
        this.numColumns.setRange(1, 64);
        this.numColumns.setSelection(this.config.getNumColumns());
        this.checkFullColors = new Button(dialogArea, 32);
        Messages.get();
        this.checkFullColors.setText(Messages.StatusIndicator_UseFullColorRange);
        this.checkFullColors.setSelection(this.config.isFullColorRange());
        return dialogArea;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setLabelType(this.labelType.getSelectionIndex());
        this.config.setShape(this.shape.getSelectionIndex());
        this.config.setNumColumns(this.numColumns.getSelection());
        this.config.setFullColorRange(this.checkFullColors.getSelection());
        return true;
    }
}

