/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class NotificationChannelEditDialog
extends Dialog {
    private NotificationChannel channel;
    private LabeledText textName;
    private LabeledText textDescription;
    private LabeledText textConfiguraiton;
    private Combo comboDriverName;
    private boolean customName;

    public NotificationChannelEditDialog(Shell parentShell, NotificationChannel channel) {
        super(parentShell);
        this.channel = channel;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboDriverName = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Driver", (Object)gd);
        this.comboDriverName.addModifyListener(listener -> {
            int selectionIndex = this.comboDriverName.getSelectionIndex();
            if (selectionIndex != -1 && !this.customName) {
                this.textName.setText(this.comboDriverName.getItem(selectionIndex));
                this.textName.getTextControl().selectAll();
            }
        });
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel("Name");
        this.textName.getTextControl().setTextLimit(63);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        this.textName.getTextControl().addModifyListener(listener -> {
            Button button;
            String name = this.textName.getText();
            int selectionIndex = this.comboDriverName.getSelectionIndex();
            if (selectionIndex != -1) {
                String driver = this.comboDriverName.getItem(selectionIndex);
                boolean bl = this.customName = !name.equals(driver);
            }
            if ((button = this.getButton(0)) != null) {
                button.setEnabled(!name.trim().isBlank());
            }
        });
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel("Description");
        this.textDescription.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
        this.textConfiguraiton = new LabeledText(dialogArea, 0, 2050);
        this.textConfiguraiton.setLabel("Driver Configuration");
        this.textConfiguraiton.getTextControl().setFont(JFaceResources.getTextFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 900;
        this.textConfiguraiton.setLayoutData((Object)gd);
        if (this.channel != null) {
            this.textName.setText(this.channel.getName());
            this.textDescription.setText(this.channel.getDescription());
            this.textConfiguraiton.setText(this.channel.getConfiguration());
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get driver names", null, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List ncList = session.getNotificationDrivers();
                Collections.sort(ncList, String.CASE_INSENSITIVE_ORDER);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NotificationChannelEditDialog.this.updateUI(ncList);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get driver names";
            }
        }.start();
        return dialogArea;
    }

    private void updateUI(List<String> ncList) {
        int index = 0;
        if (!ncList.isEmpty()) {
            int i = 0;
            while (i < ncList.size()) {
                String item = ncList.get(i);
                this.comboDriverName.add(item);
                if (this.channel != null && item.equals(this.channel.getDriverName())) {
                    this.customName = !this.textName.getText().equals(this.channel.getDriverName());
                    index = i;
                }
                ++i;
            }
            this.comboDriverName.select(index);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.channel != null ? "Edit Notification Channel" : "Create Notification Channel");
    }

    protected void okPressed() {
        if (this.textName.getText().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Notification channel name should not be empty");
            return;
        }
        if (this.comboDriverName.getSelectionIndex() == -1) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Notification driver should be selected");
            return;
        }
        if (this.channel == null) {
            this.channel = new NotificationChannel();
        }
        this.channel.setName(this.textName.getText());
        this.channel.setDescription(this.textDescription.getText());
        this.channel.setDriverName(this.comboDriverName.getItem(this.comboDriverName.getSelectionIndex()));
        this.channel.setConfiguration(this.textConfiguraiton.getText());
        super.okPressed();
    }

    public NotificationChannel getChannel() {
        return this.channel;
    }
}

