/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.propertypages;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;

public class ZoneAgentCredentials
extends PropertyPage {
    private Zone zone;
    private List<String> sharedSecrets;
    private List<Integer> ports;
    private TableViewer secretList;
    private Button secretMoveUpButton;
    private Button secretMoveDownButton;
    private Button secretAddButton;
    private Button secretDeleteButton;
    private TableViewer portList;
    private Button portMoveUpButton;
    private Button portMoveDownButton;
    private Button portAddButton;
    private Button portDeleteButton;
    private int modified = 0;

    protected Control createContents(Composite parent) {
        this.zone = (Zone)this.getElement().getAdapter(Zone.class);
        this.noDefaultAndApplyButton();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.createSecretSection(dialogArea);
        this.createPortSection(dialogArea);
        this.loadConfig();
        return dialogArea;
    }

    private void createSecretSection(Composite dialogArea) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText("Shared secrets");
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        clientArea.setLayoutData((Object)gridData);
        this.secretList = new TableViewer((Composite)clientArea, 67586);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        this.secretList.getTable().setLayoutData((Object)gridData);
        this.secretList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite((Composite)clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.secretMoveUpButton = new Button(buttonsLeft, 8);
        this.secretMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.secretMoveUpButton.setLayoutData((Object)rd);
        this.secretMoveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.moveSharedSecret(true);
            }
        });
        this.secretMoveDownButton = new Button(buttonsLeft, 8);
        this.secretMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.secretMoveDownButton.setLayoutData((Object)rd);
        this.secretMoveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.moveSharedSecret(false);
            }
        });
        Composite buttonsRight = new Composite((Composite)clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.secretAddButton = new Button(buttonsRight, 8);
        this.secretAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.secretAddButton.setLayoutData((Object)rd);
        this.secretAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.addSharedSecret();
            }
        });
        this.secretDeleteButton = new Button(buttonsRight, 8);
        this.secretDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.secretDeleteButton.setLayoutData((Object)rd);
        this.secretDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.removeSharedSecret();
            }
        });
        this.secretList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ZoneAgentCredentials.this.secretList.getSelection();
                ZoneAgentCredentials.this.secretMoveUpButton.setEnabled(selection.size() == 1);
                ZoneAgentCredentials.this.secretMoveDownButton.setEnabled(selection.size() == 1);
                ZoneAgentCredentials.this.secretDeleteButton.setEnabled(selection.size() > 0);
            }
        });
    }

    private void loadConfig() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.NetworkCredentials_LoadingConfig, null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ZoneAgentCredentials.this.sharedSecrets = session.getAgentSharedSecrets(ZoneAgentCredentials.this.zone.getUIN());
                ZoneAgentCredentials.this.ports = session.getWellKnownPorts(ZoneAgentCredentials.this.zone.getUIN(), "agent");
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ZoneAgentCredentials.this.secretList.setInput((this).ZoneAgentCredentials.this.sharedSecrets);
                        (this).ZoneAgentCredentials.this.portList.setInput((this).ZoneAgentCredentials.this.ports);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorLoadingConfig;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void addSharedSecret() {
        InputDialog dlg = new InputDialog(this.getShell(), "Add Shared Secret", "Please enter shared secret", "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.sharedSecrets.add(value);
            this.secretList.refresh();
            this.setModified(8);
        }
    }

    protected void removeSharedSecret() {
        IStructuredSelection selection = this.secretList.getStructuredSelection();
        if (!selection.isEmpty()) {
            for (Object o : selection.toList()) {
                this.sharedSecrets.remove(o);
            }
            this.secretList.refresh();
            this.setModified(8);
        }
    }

    private void moveSharedSecret(boolean up) {
        IStructuredSelection selection = this.secretList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.sharedSecrets.indexOf(o);
                if (up) {
                    if (index < 1) continue;
                    Collections.swap(this.sharedSecrets, index - 1, index);
                    continue;
                }
                if (index + 1 == this.sharedSecrets.size()) continue;
                Collections.swap(this.sharedSecrets, index + 1, index);
            }
            this.secretList.refresh();
            this.setModified(8);
        }
    }

    private void createPortSection(Composite dialogArea) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText("Ports");
        clientArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.portList = new TableViewer((Composite)clientArea, 67586);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.portList.getTable().setLayoutData((Object)gd);
        this.portList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite((Composite)clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gd);
        this.portMoveUpButton = new Button(buttonsLeft, 8);
        this.portMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.portMoveUpButton.setLayoutData((Object)rd);
        this.portMoveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.movePort(true);
            }
        });
        this.portMoveDownButton = new Button(buttonsLeft, 8);
        this.portMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.portMoveDownButton.setLayoutData((Object)rd);
        this.portMoveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.movePort(false);
            }
        });
        Composite buttonsRight = new Composite((Composite)clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gd);
        this.portAddButton = new Button(buttonsRight, 8);
        this.portAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.portAddButton.setLayoutData((Object)rd);
        this.portAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.addPort();
            }
        });
        this.portDeleteButton = new Button(buttonsRight, 8);
        this.portDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.portDeleteButton.setLayoutData((Object)rd);
        this.portDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentCredentials.this.removePort();
            }
        });
        this.portList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ZoneAgentCredentials.this.portList.getSelection();
                ZoneAgentCredentials.this.portMoveUpButton.setEnabled(selection.size() == 1);
                ZoneAgentCredentials.this.portMoveDownButton.setEnabled(selection.size() == 1);
                ZoneAgentCredentials.this.portDeleteButton.setEnabled(selection.size() > 0);
            }
        });
    }

    private void addPort() {
        InputDialog dlg = new InputDialog(this.getShell(), "Add Agent Port", "Please enter agent port", "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.ports.add(Integer.parseInt(value));
            this.portList.refresh();
            this.setModified(16);
        }
    }

    private void removePort() {
        IStructuredSelection selection = (IStructuredSelection)this.portList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.ports.remove((Integer)o);
            }
            this.portList.refresh();
            this.setModified(16);
        }
    }

    private void movePort(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.portList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.ports.indexOf((Integer)o);
                if (up) {
                    if (index < 1) continue;
                    Collections.swap(this.ports, index - 1, index);
                    continue;
                }
                if (index + 1 == this.ports.size()) continue;
                Collections.swap(this.ports, index + 1, index);
            }
            this.portList.refresh();
            this.setModified(16);
        }
    }

    private void setModified(int configId) {
        this.modified |= configId;
    }

    private boolean applyChanges(boolean isApply) {
        if (this.modified == 0) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.NetworkCredentials_SaveConfig, this.zone.getObjectName()), null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if ((ZoneAgentCredentials.this.modified & 8) != 0) {
                    session.updateAgentSharedSecrets(ZoneAgentCredentials.this.zone.getUIN(), ZoneAgentCredentials.this.sharedSecrets);
                }
                if ((ZoneAgentCredentials.this.modified & 0x10) != 0) {
                    session.updateWellKnownPorts(ZoneAgentCredentials.this.zone.getUIN(), "agent", ZoneAgentCredentials.this.ports);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorSavingConfig;
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }
}

