/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpTrapParameterMapping;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.snmp.dialogs.MibSelectionDialog;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ParameterMappingEditDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(ParameterMappingEditDialog.class);
    private SnmpTrapParameterMapping pm;
    private Text description;
    private Button radioByOid;
    private Button radioByPosition;
    private Text objectId;
    private Button buttonSelect;
    private Spinner position;
    private Button checkForceText;

    public ParameterMappingEditDialog(Shell parentShell, SnmpTrapParameterMapping pm) {
        super(parentShell);
        this.pm = pm;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Edit SNMP Trap Parameter Mapping"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.description = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)this.i18n.tr("Description"), (String)this.pm.getDescription(), (Object)"WidgetHelper::default_layout_data");
        Group varbind = new Group(dialogArea, 0);
        varbind.setText(this.i18n.tr("Varbind"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        varbind.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        varbind.setLayout((Layout)layout);
        this.radioByOid = new Button((Composite)varbind, 16);
        this.radioByOid.setText(this.i18n.tr("By object ID (OID)"));
        this.radioByOid.setSelection(this.pm.getType() == 0);
        this.radioByOid.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite oidSelection = new Composite((Composite)varbind, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        oidSelection.setLayout((Layout)layout);
        this.objectId = new Text(oidSelection, 2048);
        if (this.pm.getType() == 0) {
            this.objectId.setText(this.pm.getObjectId().toString());
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.objectId.setLayoutData((Object)gd);
        this.buttonSelect = new Button(oidSelection, 8);
        this.buttonSelect.setText(this.i18n.tr("&Select..."));
        gd = new GridData();
        gd.widthHint = 90;
        this.buttonSelect.setLayoutData((Object)gd);
        this.buttonSelect.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.radioByPosition = new Button((Composite)varbind, 16);
        this.radioByPosition.setText(this.i18n.tr("By position"));
        this.radioByPosition.setSelection(this.pm.getType() == 1);
        this.radioByPosition.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite positionSelection = new Composite((Composite)varbind, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        positionSelection.setLayout((Layout)layout);
        this.position = new Spinner(positionSelection, 2048);
        this.position.setIncrement(1);
        this.position.setMaximum(255);
        this.position.setMinimum(1);
        this.position.setSelection(this.pm.getPosition());
        gd = new GridData();
        gd.widthHint = 40;
        this.position.setLayoutData((Object)gd);
        new Label(positionSelection, 0).setText(this.i18n.tr("Enter varbind's position in range 1 .. 255"));
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        optionsGroup.setLayout((Layout)new RowLayout(512));
        this.checkForceText = new Button((Composite)optionsGroup, 32);
        this.checkForceText.setText(this.i18n.tr("&Never convert value to hex string"));
        this.checkForceText.setSelection((this.pm.getFlags() & 1) != 0);
        this.enableControls(this.pm.getType() == 0);
        return dialogArea;
    }

    private void selectObjectId() {
        SnmpObjectId oid;
        try {
            oid = SnmpObjectId.parseSnmpObjectId((String)this.objectId.getText());
        }
        catch (SnmpObjectIdFormatException e) {
            oid = null;
        }
        MibSelectionDialog dlg = new MibSelectionDialog(this.getShell(), oid, 0L);
        if (dlg.open() == 0) {
            this.objectId.setText(dlg.getSelectedObjectId().toString());
            this.objectId.setFocus();
        }
    }

    private void enableControls(boolean mappingByOid) {
        this.objectId.setEnabled(mappingByOid);
        this.buttonSelect.setEnabled(mappingByOid);
        this.position.setEnabled(!mappingByOid);
    }

    protected void okPressed() {
        int type;
        int n = type = this.radioByOid.getSelection() ? 0 : 1;
        if (type == 0) {
            try {
                this.pm.setObjectId(SnmpObjectId.parseSnmpObjectId((String)this.objectId.getText()));
            }
            catch (SnmpObjectIdFormatException e) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("SNMP OID you have entered is invalid. Please enter correct SNMP OID."));
                return;
            }
        } else {
            this.pm.setPosition(this.position.getSelection());
        }
        this.pm.setType(type);
        this.pm.setDescription(this.description.getText());
        this.pm.setFlags(this.checkForceText.getSelection() ? 1 : 0);
        super.okPressed();
    }
}

