/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.topology.RadioInterface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.tools.ViewerElementUpdater;

public class RadioInterfaceControllerLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private TableViewer viewer;
    private NXCSession session = Registry.getSession();

    public RadioInterfaceControllerLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        RadioInterface rif = (RadioInterface)element;
        switch (columnIndex) {
            case 1: {
                return ((AccessPoint)rif.getOwner()).getMacAddress().toString();
            }
            case 3: {
                return ((AccessPoint)rif.getOwner()).getModel();
            }
            case 0: {
                return ((AccessPoint)rif.getOwner()).getObjectName();
            }
            case 4: {
                return ((AccessPoint)rif.getOwner()).getSerialNumber();
            }
            case 2: {
                return ((AccessPoint)rif.getOwner()).getVendor();
            }
            case 10: {
                return rif.getBand().toString();
            }
            case 8: {
                return rif.getBSSID().toString();
            }
            case 11: {
                return rif.getChannel() > 0 ? Integer.toString(rif.getChannel()) : "";
            }
            case 12: {
                return rif.getFrequency() > 0 ? Integer.toString(rif.getFrequency()) + " MHz" : "";
            }
            case 5: {
                return Integer.toString(rif.getIndex());
            }
            case 9: {
                return this.session.getVendorByMac(rif.getBSSID(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
            }
            case 6: {
                return rif.getName();
            }
            case 7: {
                return rif.getSSID();
            }
            case 13: {
                return Integer.toString(rif.getPowerDBm());
            }
            case 14: {
                return Integer.toString(rif.getPowerMW());
            }
        }
        return null;
    }
}

