/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.views;

import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.LogDescriptorRegistry;
import org.netxms.nxmc.modules.logviewer.views.LogViewer;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.services.LogDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogViewerPerspective
extends Perspective {
    private static final Logger logger = LoggerFactory.getLogger(LogViewerPerspective.class);

    public LogViewerPerspective() {
        super("logs", LocalizationHelper.getI18n(LogViewerPerspective.class).tr("Logs"), ResourceManager.getImage((String)"icons/perspective-logs.png"));
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = false;
        configuration.multiViewMainArea = true;
        configuration.hasSupplementalArea = false;
        configuration.priority = 100;
        configuration.ignoreViewContext = true;
    }

    protected void configureViews() {
        NXCSession session = Registry.getSession();
        for (LogDescriptor log : ((LogDescriptorRegistry)Registry.getSingleton(LogDescriptorRegistry.class)).getDescriptors()) {
            if (log.isValidForSession(session)) {
                LogViewer view = log.createView();
                this.addMainView((View)view);
                logger.debug("Added logs perspective view \"" + view.getName() + "\"");
                continue;
            }
            logger.debug("Logs perspective view \"" + log.getViewTitle() + "\" blocked by filter");
        }
    }
}

