/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.util.Map;
import java.util.Set;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="element", strict=false)
public class ServiceComponentsConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=false)
    private int zoomLevel = 100;
    @Element(required=false)
    private boolean objectDoubleClickEnabled = false;
    @Element(required=false)
    private MapObjectDisplayMode objectDisplayMode = MapObjectDisplayMode.ICON;
    @Element(required=false)
    private int flags = 0;
    @Element(required=false)
    private int linkRouting = 0;
    @Element(required=false)
    private int defaultLinkColor = -1;
    @Element(required=false)
    private MapLayoutAlgorithm mapLayout = MapLayoutAlgorithm.SPARSE_VTREE;

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    @Override
    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public boolean isObjectDoubleClickEnabled() {
        return this.objectDoubleClickEnabled;
    }

    public void setObjectDoubleClickEnabled(boolean objectDoubleClickEnabled) {
        this.objectDoubleClickEnabled = objectDoubleClickEnabled;
    }

    public MapObjectDisplayMode getObjectDisplayMode() {
        return this.objectDisplayMode;
    }

    public void setObjectDisplayMode(MapObjectDisplayMode mode) {
        this.objectDisplayMode = mode;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getDefaultLinkRouting() {
        return this.linkRouting;
    }

    public void setDefaultLinkRouting(int linkRouting) {
        this.linkRouting = linkRouting;
    }

    public int getDefaultLinkColor() {
        return this.defaultLinkColor;
    }

    public void setDefaultLinkColor(int defaultLinkColor) {
        this.defaultLinkColor = defaultLinkColor;
    }

    public MapLayoutAlgorithm getDefaultLayoutAlgorithm() {
        return this.mapLayout;
    }

    public void setDefaultLayoutAlgorithm(MapLayoutAlgorithm algorithm) {
        this.mapLayout = algorithm;
    }
}

