/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.MarkdownViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class AiAssistantChatView
extends View {
    private final I18n i18n = LocalizationHelper.getI18n(AiAssistantChatView.class);
    private NXCSession session = Registry.getSession();
    private MarkdownViewer chatOutput;
    private Text chatInput;
    private Action actionClearOutput;

    public AiAssistantChatView() {
        super(LocalizationHelper.getI18n(AiAssistantChatView.class).tr("AI Assistant"), ResourceManager.getImageDescriptor((String)"icons/tool-views/ai-assistant.png"), "tools.ai-assistant", false);
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        AiAssistantChatView view = (AiAssistantChatView)origin;
        this.chatOutput.setText(view.chatOutput.getText());
        this.chatInput.setText(view.chatInput.getText());
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.chatOutput = new MarkdownViewer(parent, 0);
        this.chatOutput.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chatOutput.setText("!v AI assistant chat is ready. Enter your query and press enter to get assistant's response.\n\n");
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite commandArea = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        commandArea.setLayout((Layout)layout);
        commandArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(commandArea, 0);
        label.setText(this.i18n.tr("Query:"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.chatInput = new Text(commandArea, 2048);
        this.chatInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.chatInput.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    private void createActions() {
        this.actionClearOutput = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClearOutput);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClearOutput);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClearOutput);
    }

    public void setFocus() {
        this.chatInput.setFocus();
    }

    private void sendQuery() {
        String prompt = this.chatInput.getText().trim();
        this.chatInput.setText("");
        if (prompt.isEmpty()) {
            return;
        }
        this.chatOutput.setText(this.chatOutput.getText() + "\n! " + prompt + "\n");
        this.chatInput.setEnabled(false);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

