/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.widgets.ConditionEditor;
import org.xnap.commons.i18n.I18n;

public class TextConditionEditor
extends ConditionEditor {
    private final I18n i18n = LocalizationHelper.getI18n(TextConditionEditor.class);
    private final String[] OPERATIONS = new String[]{this.i18n.tr("LIKE"), this.i18n.tr("NOT LIKE")};
    private Text value;

    public TextConditionEditor(Composite parent) {
        super(parent);
    }

    protected String[] getOperations() {
        return this.OPERATIONS;
    }

    protected void createContent(ColumnFilter initialFilter) {
        this.value = new Text((Composite)this, 2048);
        this.value.setText("%");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.value.setLayoutData((Object)gd);
        if (initialFilter != null && initialFilter.getType() == ColumnFilterType.LIKE) {
            this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
            this.value.setText(initialFilter.getLike());
        }
    }

    public ColumnFilter createFilter() {
        ColumnFilter filter = new ColumnFilter(this.value.getText());
        filter.setNegated(this.getSelectedOperation() == 1);
        return filter;
    }
}

