/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.views;

import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.LogDescriptorRegistry;
import org.netxms.nxmc.modules.logviewer.views.LogViewer;
import org.netxms.nxmc.services.LogDescriptor;
import org.xnap.commons.i18n.I18n;

public class ObjectLogViewer
extends LogViewer {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectLogViewer.class);
    private LogDescriptor logDescriptor;
    private AbstractObject object;
    private long contextId;
    private boolean restored = false;

    protected ObjectLogViewer() {
    }

    public ObjectLogViewer(LogDescriptor logDescriptor, AbstractObject object, long contextId) {
        super(logDescriptor.getViewTitle(), logDescriptor.getLogName());
        this.logDescriptor = logDescriptor;
        this.contextId = contextId;
        this.object = object;
    }

    protected void postClone(View view) {
        ObjectLogViewer origin = (ObjectLogViewer)view;
        this.logDescriptor = origin.logDescriptor;
        this.contextId = origin.contextId;
        this.object = origin.object;
        super.postClone(view);
    }

    protected void postContentCreate() {
        if (!this.restored) {
            this.queryWithFilter(this.logDescriptor.createFilter(this.object));
        }
        super.postContentCreate();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject && (((AbstractObject)context).getObjectId() == this.object.getObjectId() || ((AbstractObject)context).getObjectId() == this.contextId);
    }

    protected String getContextName() {
        return this.object.getObjectName();
    }

    public String getFullName() {
        return this.getName() + " - " + this.getContextName();
    }

    public boolean isCloseable() {
        return true;
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("contextId", this.contextId);
        memento.set("objectId", this.object.getObjectId());
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.logDescriptor = ((LogDescriptorRegistry)Registry.getSingleton(LogDescriptorRegistry.class)).get(this.getLogName());
        this.contextId = memento.getAsLong("contextId", 0L);
        long objectId = memento.getAsLong("objectId", 0L);
        this.object = this.session.findObjectById(objectId);
        if (this.object == null) {
            throw new ViewNotRestoredException(this.i18n.tr("Invalid object id"));
        }
        this.restored = true;
    }
}

