/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.modules.dashboards.config.SeparatorConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.tools.ColorConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeparatorElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(SeparatorElement.class);
    private SeparatorConfig config;
    private Color bkColor;
    private Color fgColor;

    public SeparatorElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, 0, element, view);
        try {
            this.config = (SeparatorConfig)new Gson().fromJson(element.getData(), SeparatorConfig.class);
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new SeparatorConfig();
        }
        this.getMainArea().dispose();
        this.bkColor = new Color((Device)this.getDisplay(), ColorConverter.rgbFromInt((int)this.config.getBackgroundColorAsInt()));
        this.fgColor = new Color((Device)this.getDisplay(), ColorConverter.rgbFromInt((int)this.config.getForegroundColorAsInt()));
        this.setBackground(this.bkColor);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(wHint == -1 ? this.config.getLeftMargin() + this.config.getRightMargin() : wHint, this.config.getTopMargin() + this.config.getBottomMargin() + this.config.getLineWidth());
    }
}

