/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import org.eclipse.rap.rwt.RWT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppPropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(AppPropertiesLoader.class);
    private Properties properties = this.loadPropertyFile();
    private String resolvedServerAddress = null;
    private boolean resolveServerNameCompleted = false;

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        try {
            InitialContext context = new InitialContext();
            return context.lookup("java:comp/env/nxmc/" + name).toString();
        }
        catch (Exception context) {
            String value = this.properties.getProperty(name);
            if (value != null) {
                return value;
            }
            value = System.getProperties().getProperty("nxmc." + name);
            if (value != null) {
                return value;
            }
            value = System.getenv("NXMC_" + name.toUpperCase());
            if (value != null) {
                return value;
            }
            if (name.equals("server")) {
                if (!this.resolveServerNameCompleted) {
                    try {
                        InetAddress addr = InetAddress.getByName("NETXMS_SERVER");
                        this.resolvedServerAddress = addr.getHostAddress();
                        logger.info("Server address resolved from NETXMS_SERVER: " + this.resolvedServerAddress);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    this.resolveServerNameCompleted = true;
                }
                if (this.resolvedServerAddress != null) {
                    return this.resolvedServerAddress;
                }
            }
            return defaultValue;
        }
    }

    public int getPropertyAsInteger(String name, int defaultValue) {
        String value = this.getProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        String value = this.getProperty(name, null);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertyFile() {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            ServletContext context;
            in = this.getClass().getResourceAsStream("/nxmc.properties");
            if (in == null && (context = RWT.getRequest().getSession().getServletContext()) != null) {
                in = context.getResourceAsStream("/nxmc.properties");
            }
            if (in != null) {
                properties.load(in);
                logger.info("Properties loaded from nxmc.properties");
                properties.forEach((BiConsumer<? super Object, ? super Object>)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                logger.info("Property file nxmc.properties not found in classpath");
            }
        }
        catch (Exception e) {
            logger.warn("Cannot load property file nxmc.properties", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }
}

