/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.CopyTableCellsAction;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.LastValues;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.helpers.OverviewDciLabelProvider;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class LastValues
extends OverviewPageElement {
    private static Logger logger = LoggerFactory.getLogger(LastValues.class);
    private final I18n i18n = LocalizationHelper.getI18n(LastValues.class);
    private TableViewer viewer;
    private ViewRefreshController refreshController;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopyValue;

    public LastValues(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
        this.refreshController = new ViewRefreshController((View)objectView, -1, () -> this.refresh());
    }

    protected String getTitle() {
        return this.i18n.tr("Last Values");
    }

    public boolean isApplicableForObject(AbstractObject object) {
        if (!(object instanceof DataCollectionTarget)) {
            return false;
        }
        return !((DataCollectionTarget)object).getOverviewDciData().isEmpty();
    }

    protected Control createClientArea(Composite parent) {
        this.viewer = new TableViewer(parent, 98562);
        this.setupTable();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OverviewDciLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setInput((Object)((DataCollectionTarget)this.getObject()).getOverviewDciData().toArray());
        this.adjustCollumns();
        this.createActions();
        this.createPopupMenu();
        this.refreshController.setInterval(30);
        this.refresh();
        return this.viewer.getTable();
    }

    protected void createActions() {
        this.actionCopy = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        this.actionCopyName = new CopyTableCellsAction((ColumnViewer)this.viewer, 0, true, this.i18n.tr("Copy &name to clipboard"));
        this.actionCopyValue = new CopyTableCellsAction((ColumnViewer)this.viewer, 1, true, this.i18n.tr("Copy &value to clipboard"));
    }

    private void adjustCollumns() {
        for (TableColumn cl : this.viewer.getTable().getColumns()) {
            cl.pack();
            cl.setWidth(cl.getWidth() + 10);
        }
    }

    private void setupTable() {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(this.i18n.tr("Metric"));
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(this.i18n.tr("Value"));
        tc.setWidth(100);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(this.i18n.tr("Timestamp"));
        tc.setWidth(100);
        this.viewer.getTable().setHeaderVisible(false);
        this.viewer.getTable().setLinesVisible(false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopyValue);
    }

    protected void onObjectChange() {
        this.viewer.setInput((Object)((DataCollectionTarget)this.getObject()).getOverviewDciData().toArray());
        this.adjustCollumns();
    }

    private void refresh() {
        NXCSession session = Registry.getSession();
        long nodeId = this.getObject().getObjectId();
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }
}

