/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.dialogs.EditGroupBoxDialog;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetFactory;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditGroupBoxDialog
extends Dialog {
    private static final RGB DEFAULT_COLOR = new RGB(64, 105, 156);
    private I18n i18n = LocalizationHelper.getI18n(EditGroupBoxDialog.class);
    private LabeledText textTitle;
    private Spinner spinnerWidth;
    private Spinner spinnerHeight;
    private ColorSelector colorSelector;
    private NetworkMapDecoration groupBox;

    public EditGroupBoxDialog(Shell parentShell, NetworkMapDecoration groupBox) {
        super(parentShell);
        this.groupBox = groupBox;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Group Box Properties"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.textTitle = new LabeledText(dialogArea, 0);
        this.textTitle.setLabel(this.i18n.tr("Title"));
        this.textTitle.setText(this.groupBox.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textTitle.setLayoutData((Object)gd);
        Composite attrArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        attrArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        attrArea.setLayoutData((Object)gd);
        1 factory = new /* Unavailable Anonymous Inner Class!! */;
        this.spinnerWidth = (Spinner)WidgetHelper.createLabeledControl((Composite)attrArea, (int)0, (WidgetFactory)factory, (String)this.i18n.tr("Width"), (Object)"WidgetHelper::default_layout_data");
        this.spinnerWidth.setSelection(this.groupBox.getWidth());
        this.spinnerHeight = (Spinner)WidgetHelper.createLabeledControl((Composite)attrArea, (int)0, (WidgetFactory)factory, (String)this.i18n.tr("Height"), (Object)"WidgetHelper::default_layout_data");
        this.spinnerHeight.setSelection(this.groupBox.getHeight());
        this.colorSelector = WidgetHelper.createLabeledColorSelector((Composite)attrArea, (String)this.i18n.tr("Color"), (Object)"WidgetHelper::default_layout_data");
        this.colorSelector.setColorValue(DEFAULT_COLOR);
        return dialogArea;
    }

    protected void okPressed() {
        this.groupBox.setTitle(this.textTitle.getText());
        this.groupBox.setSize(this.spinnerWidth.getSelection(), this.spinnerHeight.getSelection());
        this.groupBox.setColor(ColorConverter.rgbToInt((RGB)this.colorSelector.getColorValue()));
        super.okPressed();
    }
}

