/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.StatusIndicatorElementEditDialog;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.propertypages.StatusIndicatorElements;
import org.xnap.commons.i18n.I18n;

public class StatusIndicatorElements
extends DashboardElementPropertyPage {
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_OBJECT = 2;
    public static final int COLUMN_METRIC = 3;
    public static final int COLUMN_LABEL = 4;
    private final I18n i18n = LocalizationHelper.getI18n(StatusIndicatorElements.class);
    private StatusIndicatorConfig config;
    private List<StatusIndicatorConfig.StatusIndicatorElementConfig> elements;
    private ElementLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    public StatusIndicatorElements(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(StatusIndicatorElements.class).tr("Elements"), elementConfig);
    }

    public String getId() {
        return "status-indicator-elements";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof StatusIndicatorConfig;
    }

    public int getPriority() {
        return 10;
    }

    protected Control createContents(Composite parent) {
        this.config = (StatusIndicatorConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        this.elements = new ArrayList();
        for (StatusIndicatorConfig.StatusIndicatorElementConfig e : this.config.getElements()) {
            this.elements.add(new StatusIndicatorConfig.StatusIndicatorElementConfig(e));
        }
        this.labelProvider = new ElementLabelProvider(this);
        this.labelProvider.resolveDciNames((Collection)this.elements);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Pos"), this.i18n.tr("Type"), this.i18n.tr("Object/Tag"), this.i18n.tr("Metric"), this.i18n.tr("Label")};
        int[] columnWidths = new int[]{40, 90, 200, 200, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.setInput((Object)this.elements);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 2;
        buttonLayout.marginWidth = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        GridData gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.upButton.setLayoutData((Object)gd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("Dow&n"));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.downButton.setLayoutData((Object)gd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new GridLayout();
        buttonLayout.numColumns = 3;
        buttonLayout.marginWidth = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(rightButtons, 8);
        this.editButton.setText(this.i18n.tr("&Edit..."));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        gd = new GridData();
        gd.minimumWidth = 90;
        gd.grabExcessHorizontalSpace = true;
        this.deleteButton.setLayoutData((Object)gd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addElement() {
        StatusIndicatorElementEditDialog dlg = new StatusIndicatorElementEditDialog(this.getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        StatusIndicatorConfig.StatusIndicatorElementConfig element = dlg.getElement();
        this.elements.add(element);
        if (element.getType() == 1) {
            this.labelProvider.addCacheEntry(element.getObjectId(), element.getDciId(), dlg.getCachedDciName());
        }
        this.viewer.refresh();
    }

    private void editElement() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        StatusIndicatorConfig.StatusIndicatorElementConfig element = (StatusIndicatorConfig.StatusIndicatorElementConfig)selection.getFirstElement();
        if (element == null) {
            return;
        }
        StatusIndicatorElementEditDialog dlg = new StatusIndicatorElementEditDialog(this.getShell(), element);
        if (dlg.open() == 0) {
            if (element.getType() == 1) {
                this.labelProvider.addCacheEntry(element.getObjectId(), element.getDciId(), dlg.getCachedDciName());
            }
            this.viewer.update((Object)element, null);
        }
    }

    private void deleteElements() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.elements.remove(o);
        }
        this.viewer.refresh();
    }

    private void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.elements, index - 1, index);
            this.viewer.refresh();
        }
    }

    private void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = selection.getFirstElement())) < this.elements.size() - 1 && index >= 0) {
            Collections.swap(this.elements, index + 1, index);
            this.viewer.refresh();
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.config.setElements(this.elements.toArray(new StatusIndicatorConfig.StatusIndicatorElementConfig[this.elements.size()]));
        return true;
    }
}

