/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.packages.PackageDeploymentJob;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentJobComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentJobFilter;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.DeploymentJobLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class DeploymentJobManager
extends ConfigurationView
implements SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentJobManager.class);
    private final I18n i18n = LocalizationHelper.getI18n(DeploymentJobManager.class);
    public static final String ID = "configuration.deployment-job-manager";
    public static final int COL_ID = 0;
    public static final int COL_NODE = 1;
    public static final int COL_USER = 2;
    public static final int COL_STATUS = 3;
    public static final int COL_ERROR_MESSAGE = 4;
    public static final int COL_CREATION_TIME = 5;
    public static final int COL_EXECUTION_TIME = 6;
    public static final int COL_COMPLETION_TIME = 7;
    public static final int COL_PACKAGE_ID = 8;
    public static final int COL_PACKAGE_TYPE = 9;
    public static final int COL_PACKAGE_NAME = 10;
    public static final int COL_PLATFORM = 11;
    public static final int COL_VERSION = 12;
    public static final int COL_FILE = 13;
    public static final int COL_DESCRIPTION = 14;
    private NXCSession session = Registry.getSession();
    private Map<Long, PackageDeploymentJob> jobs = new HashMap();
    private SortableTableViewer viewer;
    private DeploymentJobFilter filter;
    private Action actionCancel;
    private Action actionHideInactive;
    private Action actionExportToCsv;

    public DeploymentJobManager() {
        super(LocalizationHelper.getI18n(DeploymentJobManager.class).tr("Package Deployment Jobs"), ResourceManager.getImageDescriptor((String)"icons/config-views/deployment-jobs.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Node"), this.i18n.tr("User"), this.i18n.tr("Status"), this.i18n.tr("Error message"), this.i18n.tr("Creation time"), this.i18n.tr("Execution time"), this.i18n.tr("Completion time"), this.i18n.tr("Package ID"), this.i18n.tr("Package type"), this.i18n.tr("Package name"), this.i18n.tr("Platform"), this.i18n.tr("Version"), this.i18n.tr("File"), this.i18n.tr("Description")};
        int[] widths = new int[]{80, 140, 140, 70, 200, 120, 120, 120, 80, 100, 150, 120, 120, 300, 300};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DeploymentJobLabelProvider((TableViewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new DeploymentJobComparator());
        this.filter = new DeploymentJobFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)ID);
        this.viewer.getTable().addDisposeListener((DisposeListener & Serializable)e -> WidgetHelper.saveTableViewerSettings((SortableTableViewer)this.viewer, (String)ID));
        this.createActions();
        this.createPopupMenu();
        this.refresh();
        this.session.addListener((SessionListener)this);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        new /* Unavailable Anonymous Inner Class!! */.start();
        super.dispose();
    }

    private void createActions() {
        this.actionCancel = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideInactive = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            if (((PackageDeploymentJob)o).isFinished()) continue;
            manager.add((IAction)this.actionCancel);
            manager.add((IContributionItem)new Separator());
            break;
        }
        manager.add((IAction)this.actionHideInactive);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        super.fillLocalMenu(manager);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void cancelJob() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Cancel Job"), (String)this.i18n.tr("Selected jobs will be cancelled. Are you sure?"))) {
            return;
        }
        Object[] jobs = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 10) {
            this.getDisplay().asyncExec(() -> {
                PackageDeploymentJob j = (PackageDeploymentJob)n.getObject();
                this.jobs.put(j.getId(), j);
                this.viewer.refresh();
            });
        }
    }
}

