/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;

public abstract class LabeledControl
extends Composite {
    private static final Image ERROR_ICON = ResourceManager.getImage((String)"icons/labeled-control-alert.png");
    protected Label label;
    protected Control control;
    protected int controlWidthHint;
    private CLabel errorMessage;

    public LabeledControl(Composite parent, int style) {
        super(parent, style);
        this.controlWidthHint = -1;
        this.createContent(this.getDefaultControlStyle(), null);
    }

    public LabeledControl(Composite parent, int style, int controlStyle) {
        this(parent, style, controlStyle, -1, null);
    }

    public LabeledControl(Composite parent, int style, int controlStyle, int controlWidthHint) {
        this(parent, style, controlStyle, controlWidthHint, null);
    }

    public LabeledControl(Composite parent, int style, int controlStyle, int controlWidthHint, Object parameters) {
        super(parent, style);
        this.controlWidthHint = controlWidthHint;
        this.createContent(controlStyle, parameters);
    }

    protected abstract Control createControl(int var1, Object var2);

    protected int getDefaultControlStyle() {
        return 2048;
    }

    protected boolean isExtraVerticalSpaceNeeded(int controlStyle) {
        return false;
    }

    private void createContent(int controlStyle, Object parameters) {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.label.setLayoutData((Object)gd);
        this.control = this.createControl(controlStyle, parameters);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        if (this.isExtraVerticalSpaceNeeded(controlStyle)) {
            gd.verticalAlignment = 4;
            gd.grabExcessVerticalSpace = true;
        } else {
            gd.verticalAlignment = 128;
        }
        gd.widthHint = this.controlWidthHint;
        this.control.setLayoutData((Object)gd);
    }

    public void setLabel(String newLabel) {
        this.label.setText(newLabel);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public Label getLabelControl() {
        return this.label;
    }

    public abstract void setText(String var1);

    public abstract String getText();

    public Control getControl() {
        return this.control;
    }

    public void setErrorMessage(String message) {
        if (message == null) {
            if (this.errorMessage != null) {
                this.errorMessage.dispose();
                this.errorMessage = null;
                this.layout(true, true);
            }
            return;
        }
        if (this.errorMessage == null) {
            this.errorMessage = new CLabel((Composite)this, 0);
            this.errorMessage.setForeground(ThemeEngine.getForegroundColor((String)"List.Error"));
            this.errorMessage.setText(message);
            this.errorMessage.setImage(ERROR_ICON);
            this.layout(true, true);
        } else {
            this.errorMessage.setText(message);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.control.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.control.setFocus();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.label.setBackground(color);
    }

    public String toString() {
        return this.getClass().getName() + " [label=" + this.label.getText() + ", control=" + String.valueOf(this.control) + "]";
    }
}

