/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Memento {
    private static final RGB DEFAULT_COLOR = new RGB(0, 0, 0);
    private static final Logger logger = LoggerFactory.getLogger(HistoricalGraphView.class);
    protected Properties properties;
    protected Properties defaultValues = new Properties();

    public static String serverProperty(String baseName, NXCSession session) {
        return baseName + "$" + Long.toString(session.getServerId());
    }

    public static String serverProperty(String baseName) {
        return Memento.serverProperty((String)baseName, (NXCSession)Registry.getSession());
    }

    public Memento() {
        this.properties = new Properties(this.defaultValues);
    }

    protected void onPropertyChange(String property, String oldValue, String newValue) {
    }

    public String getAsString(String name) {
        return this.properties.getProperty(name);
    }

    public String getAsString(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public boolean getAsBoolean(String name, boolean defaultValue) {
        String v = this.properties.getProperty(name);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    public int getAsInteger(String name, int defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getAsLong(String name, long defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double getAsDouble(String name, double defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Point getAsPoint(String name, Point defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        String[] parts = v.split(",");
        if (parts.length != 2) {
            return defaultValue;
        }
        try {
            return new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Point getAsPoint(String name, int defaultX, int defaultY) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return new Point(defaultX, defaultY);
        }
        String[] parts = v.split(",");
        if (parts.length != 2) {
            return new Point(defaultX, defaultY);
        }
        try {
            return new Point(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        catch (NumberFormatException e) {
            return new Point(defaultX, defaultY);
        }
    }

    public List<String> getAsStringList(String name) {
        int count = this.getAsInteger(name + ".Count", 0);
        ArrayList<String> list = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            list.add(this.getAsString(name + "." + Integer.toString(i), ""));
        }
        return list;
    }

    public String[] getAsStringArray(String name) {
        int count = this.getAsInteger(name + ".Count", 0);
        String[] list = new String[count];
        for (int i = 0; i < count; ++i) {
            list[i] = this.getAsString(name + "." + Integer.toString(i), "");
        }
        return list;
    }

    public RGB getAsColor(String name, RGB defaultValue) {
        String v = this.properties.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        String[] parts = v.split(",");
        if (parts.length != 3) {
            return defaultValue;
        }
        try {
            return new RGB(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public RGB getAsColor(String name) {
        return this.getAsColor(name, DEFAULT_COLOR);
    }

    public Memento getAsMemento(String name) {
        Memento memento = new Memento();
        String value = this.getAsString(name);
        if (value != null && !value.isEmpty()) {
            memento.deserialize(value);
        }
        return memento;
    }

    public UUID getAsUUID(String name) {
        String value = this.getAsString(name);
        if (value != null && !value.isEmpty()) {
            try {
                return UUID.fromString(value);
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to parse UUID", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void set(String name, String value) {
        String oldValue = this.properties.getProperty(name);
        this.properties.setProperty(name, value);
        this.onPropertyChange(name, oldValue, value);
    }

    public void set(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public void set(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public void set(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public void set(String name, double value) {
        this.set(name, Double.toString(value));
    }

    public void set(String name, Point value) {
        this.set(name, Integer.toString(value.x) + "," + Integer.toString(value.y));
    }

    public <T> void set(String name, Collection<T> value) {
        this.properties.setProperty(name + ".Count", Integer.toString(value.size()));
        int index = 0;
        for (T s : value) {
            this.properties.setProperty(name + "." + Integer.toString(index++), s.toString());
        }
        this.onPropertyChange(name, null, null);
    }

    public void set(String name, Memento value) {
        this.set(name, value.serialize());
    }

    public void set(String name, RGB value) {
        this.set(name, Integer.toString(value.red) + "," + Integer.toString(value.green) + "," + Integer.toString(value.blue));
    }

    public void set(String name, UUID value) {
        this.set(name, value.toString());
    }

    public void setDefault(String name, String value) {
        this.defaultValues.setProperty(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.setDefault(name, Boolean.toString(value));
    }

    public void setDefault(String name, int value) {
        this.setDefault(name, Integer.toString(value));
    }

    public void setDefault(String name, long value) {
        this.setDefault(name, Long.toString(value));
    }

    public void setDefault(String name, Point value) {
        this.setDefault(name, Integer.toString(value.x) + "," + Integer.toString(value.y));
    }

    public void setDefault(String name, Collection<String> value) {
        this.defaultValues.setProperty(name + ".Count", Integer.toString(value.size()));
        int index = 0;
        for (String s : value) {
            this.defaultValues.setProperty(name + "." + Integer.toString(index), s);
        }
    }

    public void setDefault(String name, RGB value) {
        this.setDefault(name, Integer.toString(value.red) + "," + Integer.toString(value.green) + "," + Integer.toString(value.blue));
    }

    public void remove(String name) {
        this.properties.remove(name);
    }

    protected String serialize() {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        try {
            this.properties.store(out, "");
            string = Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        out.close();
        return string;
    }

    protected void deserialize(String encoded) {
        try {
            byte[] bytes = Base64.getDecoder().decode(encoded);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.properties.clear();
            this.properties.load(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

