/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.widgets.helpers.SyslogLabelProvider;
import org.netxms.ui.eclipse.eventmanager.widgets.helpers.SyslogMonitorFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractTraceWidget;

public class SyslogTraceWidget
extends AbstractTraceWidget
implements SessionListener {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_FACILITY = 3;
    public static final int COLUMN_HOSTNAME = 4;
    public static final int COLUMN_TAG = 5;
    public static final int COLUMN_MESSAGE = 6;
    private NXCSession session = ConsoleSharedData.getSession();
    private Action actionShowColor;
    private Action actionShowIcons;
    private SyslogLabelProvider labelProvider;
    private SyslogMonitorFilter filter;

    public SyslogTraceWidget(Composite parent, int style, IViewPart viewPart) {
        super(parent, style, viewPart);
        this.session.addListener((SessionListener)this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SyslogTraceWidget.this.session.removeListener((SessionListener)SyslogTraceWidget.this);
            }
        });
    }

    protected void setupViewer(TableViewer viewer) {
        this.labelProvider = new SyslogLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.labelProvider.setShowColor(ps.getBoolean("SyslogMonitor.showColor"));
        this.labelProvider.setShowIcons(ps.getBoolean("SyslogMonitor.showIcons"));
        Messages.get();
        this.addColumn(Messages.SyslogMonitor_ColTimestamp, 150);
        Messages.get();
        this.addColumn(Messages.SyslogMonitor_ColSource, 200);
        Messages.get();
        this.addColumn(Messages.SyslogMonitor_ColSeverity, 90);
        Messages.get();
        this.addColumn(Messages.SyslogMonitor_ColFacility, 90);
        Messages.get();
        this.addColumn(Messages.SyslogMonitor_ColHostName, 130);
        Messages.get();
        this.addColumn(Messages.SyslogMonitor_ColTag, 90);
        Messages.get();
        this.addColumn(Messages.SyslogMonitor_ColMessage, 600);
        this.filter = new SyslogMonitorFilter();
        this.setFilter(this.filter);
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected String getConfigPrefix() {
        return "SyslogMonitor";
    }

    protected void saveConfig() {
        super.saveConfig();
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        ps.setValue("SyslogMonitor.showColor", this.labelProvider.isShowColor());
        ps.setValue("SyslogMonitor.showIcons", this.labelProvider.isShowIcons());
    }

    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionShowColor = new Action(Messages.SyslogMonitor_ShowStatusColors, 2){

            public void run() {
                SyslogTraceWidget.this.labelProvider.setShowColor(SyslogTraceWidget.this.actionShowColor.isChecked());
                SyslogTraceWidget.this.refresh();
            }
        };
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        Messages.get();
        this.actionShowIcons = new Action(Messages.SyslogMonitor_ShowStatusIcons, 2){

            public void run() {
                SyslogTraceWidget.this.labelProvider.setShowIcons(SyslogTraceWidget.this.actionShowIcons.isChecked());
                SyslogTraceWidget.this.refresh();
            }
        };
        this.actionShowIcons.setChecked(this.labelProvider.isShowIcons());
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 7) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SyslogTraceWidget.this.addElement(n.getObject());
                }
            });
        }
    }

    public Action getActionShowColor() {
        return this.actionShowColor;
    }

    public Action getActionShowIcons() {
        return this.actionShowIcons;
    }

    public void setRootObject(long objectId) {
        this.filter.setRootObject(objectId);
        this.refresh();
    }
}

