/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.PollState;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.MapType;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.interfaces.AutoBindObject;
import org.netxms.client.objects.interfaces.PollingTarget;

public class NetworkMap
extends GenericObject
implements AutoBindObject,
PollingTarget {
    public static final UUID GEOMAP_BACKGROUND = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");
    public static final int MF_SHOW_STATUS_ICON = 1;
    public static final int MF_SHOW_STATUS_FRAME = 2;
    public static final int MF_SHOW_STATUS_BKGND = 4;
    public static final int MF_SHOW_END_NODES = 8;
    public static final int MF_CALCULATE_STATUS = 16;
    public static final int MF_FILTER_OBJECTS = 32;
    public static final int MF_SHOW_LINK_DIRECTION = 64;
    public static final int MF_USE_L1_TOPOLOGY = 128;
    public static final int MF_CENTER_BKGND_IMAGE = 256;
    public static final int MF_TRANSLUCENT_LABEL_BKGND = 512;
    public static final int MF_DONT_UPDATE_LINK_TEXT = 1024;
    public static final int MF_FIT_BKGND_IMAGE = 2048;
    public static final int MF_FIT_TO_SCREEN = 4096;
    public static final int MF_SHOW_AS_OBJECT_VIEW = 8192;
    public static final int MF_SHOW_TRAFFIC = 16384;
    public static final int MF_BKGND_IMAGE_FLAGS = 2304;
    private MapType mapType;
    private MapLayoutAlgorithm layout;
    private UUID background;
    private GeoLocation backgroundLocation;
    private int backgroundZoom;
    private int mapWidth;
    private int mapHeight;
    private List<Long> seedObjects;
    private int defaultLinkColor;
    private int defaultLinkRouting;
    private int defaultLinkWidth;
    private int defaultLinkStyle;
    private MapObjectDisplayMode objectDisplayMode;
    private int backgroundColor;
    private int discoveryRadius;
    private String filter;
    private String linkStylingScript;
    private List<NetworkMapElement> elements;
    private List<NetworkMapLink> links;
    private boolean updateFailed;
    private int autoBindFlags;
    private String autoBindFilter;
    private int displayPriority;

    public NetworkMap(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.mapType = MapType.getByValue(msg.getFieldAsInt16(357L));
        this.layout = MapLayoutAlgorithm.getByValue(msg.getFieldAsInt32(358L));
        this.background = msg.getFieldAsUUID(360L);
        this.backgroundLocation = new GeoLocation(msg.getFieldAsDouble(385L).doubleValue(), msg.getFieldAsDouble(386L).doubleValue());
        this.backgroundZoom = msg.getFieldAsInt32(387L);
        this.mapWidth = msg.getFieldAsInt32(844L);
        this.mapHeight = msg.getFieldAsInt32(441L);
        this.seedObjects = Arrays.asList(msg.getFieldAsUInt32ArrayEx(359L));
        this.defaultLinkColor = msg.getFieldAsInt32(417L);
        this.defaultLinkRouting = msg.getFieldAsInt32(423L);
        this.defaultLinkStyle = msg.getFieldAsInt32(587L);
        this.defaultLinkWidth = msg.getFieldAsInt32(586L);
        this.objectDisplayMode = MapObjectDisplayMode.getByValue(msg.getFieldAsInt32(506L));
        this.backgroundColor = msg.getFieldAsInt32(424L);
        this.discoveryRadius = msg.getFieldAsInt32(426L);
        this.filter = msg.getFieldAsString(232L);
        this.linkStylingScript = msg.getFieldAsString(840L);
        this.updateFailed = msg.getFieldAsBoolean(383L);
        this.autoBindFilter = msg.getFieldAsString(321L);
        this.autoBindFlags = msg.getFieldAsInt32(625L);
        this.displayPriority = msg.getFieldAsInt32(795L);
        int count = msg.getFieldAsInt32(361L);
        this.elements = new ArrayList<NetworkMapElement>(count);
        long fieldId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.elements.add(NetworkMapElement.createMapElement(msg, fieldId));
            fieldId += 100L;
            ++i;
        }
        count = msg.getFieldAsInt32(214L);
        this.links = new ArrayList<NetworkMapLink>(count);
        fieldId = 0x40000000L;
        i = 0;
        while (i < count) {
            this.links.add(new NetworkMapLink(msg, fieldId));
            fieldId += 20L;
            ++i;
        }
    }

    public void prepareCopy(NXCObjectCreationData cd, NXCObjectModificationData md) {
        cd.setMapType(this.mapType);
        cd.setSeedObjectIds(this.seedObjects);
        md.setMapLayout(this.layout);
        md.setMapBackground(this.background, this.backgroundLocation, this.backgroundZoom, this.backgroundColor);
        md.setDiscoveryRadius(this.discoveryRadius);
        md.setFilter(this.filter);
        md.setLinkStylingScript(this.linkStylingScript);
        md.setMapContent(this.elements, this.links);
    }

    @Override
    public String getObjectClassName() {
        return "NetworkMap";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public MapLayoutAlgorithm getLayout() {
        return this.layout;
    }

    public UUID getBackground() {
        return this.background;
    }

    public List<Long> getSeedObjects() {
        return this.seedObjects;
    }

    public NetworkMapPage createMapPage() {
        NetworkMapPage page = new NetworkMapPage((String)this.getObjectName(), this.objectId);
        page.addAllElements(this.elements);
        page.addAllLinks(this.links);
        return page;
    }

    public GeoLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    public int getBackgroundZoom() {
        return this.backgroundZoom;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public int getDefaultLinkColor() {
        return this.defaultLinkColor;
    }

    public int getDefaultLinkRouting() {
        return this.defaultLinkRouting;
    }

    public int getDefaultLinkWidth() {
        return this.defaultLinkWidth;
    }

    public int getDefaultLinkStyle() {
        return this.defaultLinkStyle;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final int getDiscoveryRadius() {
        return this.discoveryRadius;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getLinkStylingScript() {
        return this.linkStylingScript;
    }

    public MapObjectDisplayMode getObjectDisplayMode() {
        return this.objectDisplayMode;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        NetworkMap.addString(strings, this.filter);
        NetworkMap.addString(strings, this.linkStylingScript);
        return strings;
    }

    public boolean isShowStatusIcon() {
        return (this.flags & 1) != 0;
    }

    public boolean isShowStatusFrame() {
        return (this.flags & 2) != 0;
    }

    public boolean isShowStatusBackground() {
        return (this.flags & 4) != 0;
    }

    public boolean isShowEndNodes() {
        return (this.flags & 8) != 0;
    }

    public boolean isShowLinkDirection() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isCalculateStatus() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isCenterBackgroundImage() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isTranslucentLabelBackground() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isDontUpdateLinkText() {
        return (this.flags & 0x400) != 0;
    }

    public boolean isFitBackgroundImage() {
        return (this.flags & 0x800) != 0;
    }

    public boolean isFitToScreen() {
        return (this.flags & 0x1000) != 0;
    }

    public int getWidth() {
        return this.mapWidth;
    }

    public int getHeight() {
        return this.mapHeight;
    }

    public int getDisplayPriority() {
        return this.displayPriority;
    }

    public boolean isUpdateFailed() {
        return this.updateFailed;
    }

    public void updateWithTemplateData(NXCObjectModificationData md) {
        md.setObjectFlags(this.flags);
        md.setMapBackground(this.background, this.backgroundLocation, this.backgroundZoom, this.backgroundColor);
        md.setMapSize(this.mapWidth, this.mapHeight);
        md.setFilter(this.filter);
        md.setMapObjectDisplayMode(this.objectDisplayMode);
        md.setConnectionRouting(this.defaultLinkRouting);
        md.setLinkColor(this.defaultLinkColor);
        md.setNetworkMapLinkWidth(this.defaultLinkWidth);
        md.setNetworkMapLinkStyle(this.defaultLinkStyle);
        md.setDiscoveryRadius(this.discoveryRadius);
        md.setLinkStylingScript(this.linkStylingScript);
        ArrayList<NetworkMapElement> result = new ArrayList<NetworkMapElement>(this.elements.size());
        for (NetworkMapElement e : this.elements) {
            if (e.getType() != 2 && e.getType() != 5) continue;
            result.add(e);
        }
        md.setMapContent(result, new ArrayList<NetworkMapLink>(0));
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }

    @Override
    public boolean canUseModbus() {
        return false;
    }

    @Override
    public PollState[] getPollStates() {
        return this.pollStates;
    }

    @Override
    public boolean isAutoBindEnabled() {
        return (this.autoBindFlags & 1) != 0;
    }

    @Override
    public boolean isAutoUnbindEnabled() {
        return (this.autoBindFlags & 2) != 0;
    }

    @Override
    public String getAutoBindFilter() {
        return this.autoBindFilter;
    }

    @Override
    public int getAutoBindFlags() {
        return this.autoBindFlags;
    }
}

