/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;

public class Event {
    private final long id;
    private final int code;
    private final Date timeStamp;
    private final long sourceId;
    private final long dciId;
    private final Severity severity;
    private final String message;
    private final String userTag;
    private final String[] parameters;

    public Event(NXCPMessage msg, long baseId) {
        long fieldId = baseId;
        this.id = msg.getFieldAsInt64(fieldId++);
        this.code = msg.getFieldAsInt32(fieldId++);
        this.timeStamp = msg.getFieldAsDate(fieldId++);
        this.sourceId = msg.getFieldAsInt64(fieldId++);
        this.severity = Severity.getByValue(msg.getFieldAsInt32(fieldId++));
        this.message = msg.getFieldAsString(fieldId++);
        this.userTag = msg.getFieldAsString(fieldId++);
        int count = msg.getFieldAsInt32(fieldId++);
        this.parameters = new String[count];
        int i = 0;
        while (i < count) {
            this.parameters[i] = msg.getFieldAsString(fieldId++);
            ++i;
        }
        this.dciId = msg.getFieldAsInt64(fieldId++);
    }

    public long getId() {
        return this.id;
    }

    public int getCode() {
        return this.code;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public String[] getParameters() {
        return this.parameters;
    }
}

