/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenListener;
import org.netxms.ui.eclipse.objectbrowser.api.SubtreeType;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.views.ObjectBrowser;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectStatusIndicator;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectFilter;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeComparator;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeContentProvider;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.RefreshTimer;
import org.netxms.ui.eclipse.widgets.FilterText;

public class ObjectTree
extends Composite {
    private boolean filterEnabled = true;
    private boolean statusIndicatorEnabled = false;
    private ObjectTreeViewer objectTree;
    private FilterText filterText;
    private String tooltip = null;
    private ObjectFilter filter;
    private SessionListener sessionListener = null;
    private NXCSession session = null;
    private Map<Long, AbstractObject> updatedObjects = new HashMap<Long, AbstractObject>();
    private boolean fullRefresh = false;
    private RefreshTimer refreshTimer;
    private ObjectStatusIndicator statusIndicator = null;
    private SelectionListener statusIndicatorSelectionListener = null;
    private TreeListener statusIndicatorTreeListener;
    private Set<ObjectOpenListener> openListeners = new HashSet<ObjectOpenListener>(0);
    private ObjectTreeContentProvider contentProvider;
    private boolean objectsFullySync;

    public ObjectTree(Composite parent, int style, boolean multiSelection, final Set<Integer> classFilter, boolean showFilterToolTip, boolean showFilterCloseButton) {
        super(parent, style);
        IPreferenceStore store = ConsoleSharedData.getSettings();
        this.objectsFullySync = store.getBoolean("ObjectsFullSync");
        this.session = ConsoleSharedData.getSession();
        this.refreshTimer = new RefreshTimer(this.session.getMinViewRefreshInterval(), (Control)this, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (ObjectTree.this.isDisposed() || ObjectTree.this.objectTree.getControl().isDisposed()) {
                    return;
                }
                ObjectTree.this.objectTree.getTree().setRedraw(false);
                Map<Long, AbstractObject> map = ObjectTree.this.updatedObjects;
                synchronized (map) {
                    if (ObjectTree.this.fullRefresh) {
                        ObjectTree.this.objectTree.refresh();
                        ObjectTree.this.fullRefresh = false;
                    } else {
                        ObjectTree.this.objectTree.refreshObjects(ObjectTree.this.updatedObjects.values());
                    }
                    ObjectTree.this.updatedObjects.clear();
                }
                if (ObjectTree.this.statusIndicatorEnabled) {
                    ObjectTree.this.updateStatusIndicator();
                }
                ObjectTree.this.objectTree.getTree().setRedraw(true);
            }
        });
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        if (showFilterToolTip) {
            this.tooltip = " > - Search by IP address part \n ^ - Search by exact IP address \n # - Search by ID \n / - Search by comment \n @ - Search by Zone ID";
        }
        this.filterText = new FilterText((Composite)this, 0, this.tooltip, showFilterCloseButton);
        this.setupFilterText(true);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObjectTree.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ObjectTree.this.enableFilter(false);
            }
        });
        this.objectTree = new ObjectTreeViewer(this, 0x10000000 | (multiSelection ? 2 : 4), this.objectsFullySync);
        this.contentProvider = new ObjectTreeContentProvider(this.objectsFullySync, classFilter);
        this.objectTree.setContentProvider((IContentProvider)this.contentProvider);
        this.objectTree.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.objectTree.setComparator(new ObjectTreeComparator());
        this.filter = new ObjectFilter(null, classFilter);
        this.objectTree.addFilter(this.filter);
        this.objectTree.setInput(this.session);
        this.objectTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeItem[] items = ObjectTree.this.objectTree.getTree().getSelection();
                if (items.length == 1 && !ObjectTree.this.openObject((AbstractObject)items[0].getData())) {
                    ObjectTree.this.objectTree.toggleItemExpandState(items[0]);
                }
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.getTree().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.sessionListener = new SessionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 99) {
                    Map<Long, AbstractObject> map = ObjectTree.this.updatedObjects;
                    synchronized (map) {
                        ObjectTree.this.updatedObjects.clear();
                        ObjectTree.this.fullRefresh = true;
                    }
                    ObjectTree.this.refreshTimer.execute();
                } else if (n.getCode() == 4 && (classFilter == null || classFilter.contains(((AbstractObject)n.getObject()).getObjectClass()))) {
                    Map<Long, AbstractObject> map = ObjectTree.this.updatedObjects;
                    synchronized (map) {
                        ObjectTree.this.updatedObjects.put(n.getSubCode(), (AbstractObject)n.getObject());
                    }
                    ObjectTree.this.refreshTimer.execute();
                }
            }
        };
        this.session.addListener(this.sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ObjectTree.this.session != null && ObjectTree.this.sessionListener != null) {
                    ObjectTree.this.session.removeListener(ObjectTree.this.sessionListener);
                }
            }
        });
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.enableStatusIndicator(this.statusIndicatorEnabled);
    }

    public void enableDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.objectTree.addDragSupport(3, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(ObjectTree.this.objectTree.getSelection());
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }
        });
    }

    private void setupFilterText(boolean addListener) {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        if (ps.getBoolean("ObjectBrowser.useServerFilterSettings")) {
            this.filterText.setAutoApply(this.session.getClientConfigurationHintAsBoolean("ObjectBrowser.AutoApplyFilter", true));
            this.filterText.setDelay(this.session.getClientConfigurationHintAsInt("ObjectBrowser.FilterDelay", 300));
            this.filterText.setMinLength(this.session.getClientConfigurationHintAsInt("ObjectBrowser.MinFilterStringLength", 1));
        } else {
            this.filterText.setAutoApply(ps.getBoolean("ObjectBrowser.filterAutoApply"));
            this.filterText.setDelay(ps.getInt("ObjectBrowser.filterDelay"));
            this.filterText.setMinLength(ps.getInt("ObjectBrowser.filterMinLength"));
        }
        if (addListener) {
            ps.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("ObjectBrowser.useServerFilterSettings") || event.getProperty().equals("ObjectBrowser.filterAutoApply") || event.getProperty().equals("ObjectBrowser.filterDelay") || event.getProperty().equals("ObjectBrowser.filterMinLength")) {
                        ObjectTree.this.setupFilterText(false);
                    }
                }
            });
        }
    }

    public Tree getTreeControl() {
        return this.objectTree.getTree();
    }

    public TreeViewer getTreeViewer() {
        return this.objectTree;
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.objectTree.getTree().getLayoutData();
        FormAttachment formAttachment = fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        if (this.statusIndicatorEnabled) {
            fd = (FormData)this.statusIndicator.getLayoutData();
            fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        }
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public String getFilter() {
        return this.filterText.getText();
    }

    public long getFirstSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        if (selection.isEmpty()) {
            return 0L;
        }
        return ((AbstractObject)selection.getFirstElement()).getObjectId();
    }

    public Long[] getSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        HashSet<Long> objects = new HashSet<Long>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            objects.add(((AbstractObject)it.next()).getObjectId());
        }
        return objects.toArray(new Long[objects.size()]);
    }

    public AbstractObject getFirstSelectedObject2() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        return (AbstractObject)selection.getFirstElement();
    }

    public void refresh() {
        this.objectTree.setInput(this.session);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.objectTree.getControl().setEnabled(enabled);
        this.filterText.setEnabled(enabled);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        AbstractObject obj = this.filter.getLastMatch();
        if (obj != null) {
            AbstractObject parent = this.getParent(obj);
            if (parent != null) {
                this.objectTree.expandToLevel(parent, 1);
            }
            this.objectTree.setSelection((ISelection)new StructuredSelection((Object)obj), true);
            this.objectTree.reveal(obj);
            if (this.statusIndicatorEnabled) {
                this.updateStatusIndicator();
            }
        }
        this.objectTree.refresh(false);
    }

    static int getParentPriority(AbstractObject object) {
        if (object instanceof ServiceRoot || object instanceof EntireNetwork) {
            return 3;
        }
        if (object instanceof Container || object instanceof Cluster || object instanceof Chassis || object instanceof Rack) {
            return 2;
        }
        if (object instanceof Zone || object instanceof Subnet) {
            return 1;
        }
        return 0;
    }

    private AbstractObject getParent(AbstractObject childObject) {
        AbstractObject[] parents = childObject.getParentsAsArray();
        AbstractObject parent = null;
        int parentPriority = -1;
        AbstractObject[] abstractObjectArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject p = abstractObjectArray[n2];
            int pp = ObjectTree.getParentPriority(p);
            if (pp > parentPriority) {
                parentPriority = pp;
                parent = p;
            }
            ++n2;
        }
        return parent;
    }

    public boolean isHideUnmanaged() {
        return this.filter.isHideUnmanaged();
    }

    public void setHideUnmanaged(boolean hide) {
        this.filter.setHideUnmanaged(hide);
        this.onFilterModify();
    }

    public boolean isHideTemplateChecks() {
        return this.filter.isHideTemplateChecks();
    }

    public void setHideTemplateChecks(boolean hide) {
        this.filter.setHideTemplateChecks(hide);
        this.onFilterModify();
    }

    public boolean isHideSubInterfaces() {
        return this.filter.isHideSubInterfaces();
    }

    public void setHideSubInterfaces(boolean hide) {
        this.filter.setHideSubInterfaces(hide);
        this.onFilterModify();
    }

    public void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }

    public void enableStatusIndicator(boolean enabled) {
        if (this.statusIndicatorEnabled == enabled) {
            return;
        }
        this.statusIndicatorEnabled = enabled;
        if (enabled) {
            this.statusIndicator = new ObjectStatusIndicator(this, 0);
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = this.filterEnabled ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
            fd.bottom = new FormAttachment(100, 0);
            this.statusIndicator.setLayoutData(fd);
            fd = (FormData)this.objectTree.getTree().getLayoutData();
            fd.left = new FormAttachment((Control)this.statusIndicator);
            this.statusIndicatorSelectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ObjectTree.this.updateStatusIndicator();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ObjectTree.this.updateStatusIndicator();
                }
            };
            this.objectTree.getTree().getVerticalBar().addSelectionListener(this.statusIndicatorSelectionListener);
            this.statusIndicatorTreeListener = new TreeListener(){

                public void treeCollapsed(TreeEvent e) {
                    ObjectTree.this.updateStatusIndicator();
                }

                public void treeExpanded(TreeEvent e) {
                    ObjectTree.this.updateStatusIndicator();
                }
            };
            this.objectTree.getTree().addTreeListener(this.statusIndicatorTreeListener);
            this.updateStatusIndicator();
        } else {
            this.objectTree.getTree().getVerticalBar().removeSelectionListener(this.statusIndicatorSelectionListener);
            this.objectTree.getTree().removeTreeListener(this.statusIndicatorTreeListener);
            this.statusIndicator.dispose();
            this.statusIndicator = null;
            this.statusIndicatorSelectionListener = null;
            this.statusIndicatorTreeListener = null;
            FormData fd = (FormData)this.objectTree.getTree().getLayoutData();
            fd.left = new FormAttachment(0, 0);
        }
        this.layout(true, true);
    }

    public boolean isStatusIndicatorEnabled() {
        return this.statusIndicatorEnabled;
    }

    private void updateStatusIndicator() {
        this.statusIndicator.refresh(this.objectTree);
    }

    public void addOpenListener(ObjectOpenListener listener) {
        this.openListeners.add(listener);
    }

    public void removeOpenListener(ObjectOpenListener listener) {
        this.openListeners.remove(listener);
    }

    private boolean openObject(AbstractObject object) {
        for (ObjectOpenListener l : this.openListeners) {
            if (!l.openObject(object)) continue;
            return true;
        }
        return false;
    }

    public void enableDropSupport(final ObjectBrowser obj) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.objectTree.addDropSupport(3, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.objectTree){
            int operation;
            {
                super($anonymous0);
                this.operation = 0;
            }

            public boolean performDrop(Object data) {
                TreeSelection selection = (TreeSelection)data;
                List movableSelection = selection.toList();
                int i = 0;
                while (i < movableSelection.size()) {
                    AbstractObject movableObject = (AbstractObject)movableSelection.get(i);
                    TreePath path = selection.getPaths()[0];
                    AbstractObject parent = (AbstractObject)path.getSegment(path.getSegmentCount() - 2);
                    obj.moveObject((AbstractObject)this.getCurrentTarget(), parent, movableObject, this.operation == 2);
                    ++i;
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                this.operation = operation;
                if (target == null || !LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection.isEmpty()) {
                    return false;
                }
                for (Object object : selection.toList()) {
                    SubtreeType subtree = null;
                    if (object instanceof AbstractObject) {
                        if (obj.isValidSelectionForMove(SubtreeType.INFRASTRUCTURE)) {
                            subtree = SubtreeType.INFRASTRUCTURE;
                        } else if (obj.isValidSelectionForMove(SubtreeType.TEMPLATES)) {
                            subtree = SubtreeType.TEMPLATES;
                        } else if (obj.isValidSelectionForMove(SubtreeType.BUSINESS_SERVICES)) {
                            subtree = SubtreeType.BUSINESS_SERVICES;
                        } else if (obj.isValidSelectionForMove(SubtreeType.DASHBOARDS)) {
                            subtree = SubtreeType.DASHBOARDS;
                        } else if (obj.isValidSelectionForMove(SubtreeType.MAPS)) {
                            subtree = SubtreeType.MAPS;
                        }
                    }
                    if (subtree == null) {
                        return false;
                    }
                    if (operation == 1 && subtree != SubtreeType.INFRASTRUCTURE) {
                        return false;
                    }
                    Set<Integer> filter = switch (subtree) {
                        case SubtreeType.INFRASTRUCTURE -> ObjectSelectionDialog.createContainerSelectionFilter();
                        case SubtreeType.TEMPLATES -> ObjectSelectionDialog.createTemplateGroupSelectionFilter();
                        case SubtreeType.BUSINESS_SERVICES -> ObjectSelectionDialog.createBusinessServiceSelectionFilter();
                        case SubtreeType.DASHBOARDS -> {
                            if (object instanceof DashboardGroup) {
                                yield ObjectSelectionDialog.createDashboardGroupSelectionFilter();
                            }
                            yield ObjectSelectionDialog.createDashboardSelectionFilter();
                        }
                        case SubtreeType.MAPS -> ObjectSelectionDialog.createNetworkMapGroupsSelectionFilter();
                        default -> null;
                    };
                    if (filter != null && filter.contains(((AbstractObject)target).getObjectClass()) && !target.equals(object)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public void disableRefresh() {
        this.refreshTimer.disableRefresh();
    }

    public void enableRefresh() {
        this.refreshTimer.enableRefresh();
    }
}

