/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class RackProperties
extends PropertyPage {
    private Rack rack;
    private LabeledSpinner rackHeight;
    private Combo numberingScheme;
    private Button checkFrontOnly;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.rack = (Rack)this.getElement().getAdapter(Rack.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.rackHeight = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.rackHeight.setLabel(Messages.RackProperties_Height);
        this.rackHeight.setRange(1, 50);
        this.rackHeight.setSelection(this.rack.getHeight());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.rackHeight.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Messages.get();
        this.numberingScheme = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)Messages.RackProperties_Numbering, (Object)gd);
        Messages.get();
        this.numberingScheme.add(Messages.RackProperties_BottomTop);
        Messages.get();
        this.numberingScheme.add(Messages.RackProperties_TopBottom);
        this.numberingScheme.select(this.rack.isTopBottomNumbering() ? 1 : 0);
        this.checkFrontOnly = new Button(dialogArea, 32);
        this.checkFrontOnly.setText("&Front side only");
        this.checkFrontOnly.setSelection(this.rack.isFrontSideOnly());
        this.checkFrontOnly.setLayoutData((Object)new GridData(16384, 128, true, false));
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.rack.getObjectId());
        md.setHeight(this.rackHeight.getSelection());
        md.setRackNumberingTopBottom(this.numberingScheme.getSelectionIndex() == 1);
        md.setObjectFlags(this.checkFrontOnly.getSelection() ? 65536 : 0, 65536);
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.RackProperties_UpdatingRackProperties, this.rack.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Comments_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            RackProperties.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.rackHeight.setSelection(42);
        this.numberingScheme.select(0);
        this.checkFrontOnly.setSelection(false);
    }
}

