/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AddClusterNode
implements IObjectActionDelegate {
    private Shell shell;
    private IWorkbenchPart wbPart;
    private long clusterId;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.wbPart = targetPart;
    }

    public void run(IAction action) {
        final ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.shell, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        dlg.open();
        if (dlg.getReturnCode() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.AddClusterNode_JobTitle, this.wbPart, "org.netxms.ui.eclipse.objectmanager", null){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.AddClusterNode_JobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    List objects = dlg.getSelectedObjects();
                    for (AbstractObject o : objects) {
                        session.addClusterNode(AddClusterNode.this.clusterId, o.getObjectId());
                    }
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Cluster) {
                action.setEnabled(true);
                this.clusterId = ((AbstractObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.clusterId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.clusterId = 0L;
        }
    }
}

