/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCategorySelector;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptSelector;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.ImageCombo;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class RuleAlarm
extends PropertyPage {
    private static final int ALARM_NO_ACTION = 0;
    private static final int ALARM_CREATE = 1;
    private static final int ALARM_RESOLVE = 2;
    private static final int ALARM_TERMINATE = 3;
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private int alarmAction;
    private Composite dialogArea;
    private Button alarmNoAction;
    private Button alarmCreate;
    private Button alarmResolve;
    private Button alarmTerminate;
    private Composite alarmCreationGroup;
    private Composite alarmTerminationGroup;
    private LabeledText alarmMessage;
    private LabeledText alarmKeyCreate;
    private ImageCombo alarmSeverity;
    private LabeledText alarmTimeout;
    private AlarmCategorySelector alarmCategory;
    private EventSelector timeoutEvent;
    private ScriptSelector rcaScript;
    private LabeledText alarmKeyTerminate;
    private Button checkTerminateWithRegexp;
    private Button checkCreateHelpdeskTicket;

    protected Control createContents(Composite parent) {
        String string;
        String string2;
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        this.alarmAction = this.calculateAlarmAction();
        this.dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        this.dialogArea.setLayout((Layout)layout);
        Composite radioGroup = new Composite(this.dialogArea, 0);
        RowLayout rbLayout = new RowLayout(512);
        rbLayout.marginBottom = 0;
        rbLayout.marginTop = 0;
        rbLayout.marginLeft = 0;
        rbLayout.marginRight = 0;
        radioGroup.setLayout((Layout)rbLayout);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        radioGroup.setLayoutData((Object)gd);
        this.alarmNoAction = new Button(radioGroup, 16);
        Messages.get();
        this.alarmNoAction.setText(Messages.RuleAlarm_DoNotChange);
        this.alarmNoAction.setSelection(this.alarmAction == 0);
        this.alarmNoAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RuleAlarm.this.changeAlarmAction(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.alarmCreate = new Button(radioGroup, 16);
        Messages.get();
        this.alarmCreate.setText(Messages.RuleAlarm_CreateNew);
        this.alarmCreate.setSelection(this.alarmAction == 1);
        this.alarmCreate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RuleAlarm.this.changeAlarmAction(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.alarmResolve = new Button(radioGroup, 16);
        Messages.get();
        this.alarmResolve.setText(Messages.RuleAlarm_Resolve);
        this.alarmResolve.setSelection(this.alarmAction == 2);
        this.alarmResolve.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RuleAlarm.this.changeAlarmAction(2);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.alarmTerminate = new Button(radioGroup, 16);
        Messages.get();
        this.alarmTerminate.setText(Messages.RuleAlarm_Terminate);
        this.alarmTerminate.setSelection(this.alarmAction == 3);
        this.alarmTerminate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RuleAlarm.this.changeAlarmAction(3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.alarmCreationGroup = new Composite(this.dialogArea, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.exclude = this.alarmAction != 1;
        this.alarmCreationGroup.setLayoutData((Object)gd);
        this.alarmCreationGroup.setVisible(this.alarmAction == 1);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.alarmCreationGroup.setLayout((Layout)layout);
        this.alarmMessage = new LabeledText(this.alarmCreationGroup, 0);
        Messages.get();
        this.alarmMessage.setLabel(Messages.RuleAlarm_Message);
        this.alarmMessage.setText(this.rule.getAlarmMessage());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmMessage.setLayoutData((Object)gd);
        this.alarmKeyCreate = new LabeledText(this.alarmCreationGroup, 0);
        Messages.get();
        this.alarmKeyCreate.setLabel(Messages.RuleAlarm_Key);
        this.alarmKeyCreate.setText(this.rule.getAlarmKey());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmKeyCreate.setLayoutData((Object)gd);
        Composite alarmCreationSubgroup = new Composite(this.alarmCreationGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        alarmCreationSubgroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        alarmCreationSubgroup.setLayoutData((Object)gd);
        Composite severityGroup = new Composite(alarmCreationSubgroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        severityGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        severityGroup.setLayoutData((Object)gd);
        Label label = new Label(severityGroup, 0);
        Messages.get();
        label.setText(Messages.RuleAlarm_Severity);
        this.alarmSeverity = new ImageCombo(severityGroup, 2060);
        int i = 0;
        while (i < Severity.UNKNOWN.getValue()) {
            this.alarmSeverity.add(StatusDisplayInfo.getStatusImage((int)i), StatusDisplayInfo.getStatusText((int)i));
            ++i;
        }
        Image image = StatusDisplayInfo.getStatusImage((Severity)Severity.UNKNOWN);
        Messages.get();
        this.alarmSeverity.add(image, Messages.RuleAlarm_FromEvent);
        this.alarmSeverity.select(this.rule.getAlarmSeverity().getValue());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmSeverity.setLayoutData((Object)gd);
        this.alarmTimeout = new LabeledText(alarmCreationSubgroup, 0);
        Messages.get();
        this.alarmTimeout.setLabel(Messages.RuleAlarm_Timeout);
        this.alarmTimeout.getTextControl().setTextLimit(5);
        this.alarmTimeout.setText(Integer.toString(this.rule.getAlarmTimeout()));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmTimeout.setLayoutData((Object)gd);
        this.timeoutEvent = new EventSelector(this.alarmCreationGroup, 0);
        Messages.get();
        this.timeoutEvent.setLabel(Messages.RuleAlarm_TimeoutEvent);
        this.timeoutEvent.setEventCode(this.rule.getAlarmTimeoutEvent());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.timeoutEvent.setLayoutData((Object)gd);
        this.rcaScript = new ScriptSelector(this.alarmCreationGroup, 0, false, true);
        this.rcaScript.setLabel("Root cause analysis script");
        this.rcaScript.setScriptName(this.rule.getRcaScriptName());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.rcaScript.setLayoutData((Object)gd);
        this.alarmCategory = new AlarmCategorySelector(this.alarmCreationGroup, 0);
        this.alarmCategory.setLabel("Alarm category");
        this.alarmCategory.setCategoryId(this.rule.getAlarmCategories());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.alarmCategory.setLayoutData((Object)gd);
        this.checkCreateHelpdeskTicket = new Button(this.alarmCreationGroup, 32);
        this.checkCreateHelpdeskTicket.setText("Create helpdesk ticket on alarm creation");
        this.checkCreateHelpdeskTicket.setSelection((this.rule.getFlags() & 0x2000) != 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        this.checkCreateHelpdeskTicket.setLayoutData((Object)gd);
        this.alarmTerminationGroup = new Composite(this.dialogArea, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.exclude = this.alarmAction != 3 && this.alarmAction != 2;
        this.alarmTerminationGroup.setLayoutData((Object)gd);
        this.alarmTerminationGroup.setVisible(this.alarmAction == 3 || this.alarmAction == 2);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.alarmTerminationGroup.setLayout((Layout)layout);
        this.alarmKeyTerminate = new LabeledText(this.alarmTerminationGroup, 0);
        if (this.alarmAction == 3) {
            Messages.get();
            string2 = Messages.RuleAlarm_TerminateAll;
        } else {
            Messages.get();
            string2 = Messages.RuleAlarm_ResolveAll;
        }
        this.alarmKeyTerminate.setLabel(string2);
        this.alarmKeyTerminate.setText(this.rule.getAlarmKey());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmKeyTerminate.setLayoutData((Object)gd);
        this.checkTerminateWithRegexp = new Button(this.alarmTerminationGroup, 32);
        if (this.alarmAction == 3) {
            Messages.get();
            string = Messages.RuleAlarm_UseRegexpForTerminate;
        } else {
            Messages.get();
            string = Messages.RuleAlarm_UseRegexpForResolve;
        }
        this.checkTerminateWithRegexp.setText(string);
        this.checkTerminateWithRegexp.setSelection((this.rule.getFlags() & 0x20) != 0);
        return this.dialogArea;
    }

    private int calculateAlarmAction() {
        if ((this.rule.getFlags() & 8) == 0) {
            return 0;
        }
        if (this.rule.getAlarmSeverity().compareTo((Enum)Severity.TERMINATE) < 0) {
            return 1;
        }
        if (this.rule.getAlarmSeverity() == Severity.RESOLVE) {
            return 2;
        }
        return 3;
    }

    private void changeAlarmAction(int newAction) {
        Composite group;
        if (this.alarmAction != 0) {
            group = this.alarmAction == 1 ? this.alarmCreationGroup : this.alarmTerminationGroup;
            ((GridData)group.getLayoutData()).exclude = true;
            group.setVisible(false);
        }
        this.alarmAction = newAction;
        if (this.alarmAction != 0) {
            String string;
            String string2;
            group = this.alarmAction == 1 ? this.alarmCreationGroup : this.alarmTerminationGroup;
            ((GridData)group.getLayoutData()).exclude = false;
            group.setVisible(true);
            if (this.alarmAction == 3) {
                Messages.get();
                string2 = Messages.RuleAlarm_TerminateAll;
            } else {
                Messages.get();
                string2 = Messages.RuleAlarm_ResolveAll;
            }
            this.alarmKeyTerminate.setLabel(string2);
            if (this.alarmAction == 3) {
                Messages.get();
                string = Messages.RuleAlarm_UseRegexpForTerminate;
            } else {
                Messages.get();
                string = Messages.RuleAlarm_UseRegexpForResolve;
            }
            this.checkTerminateWithRegexp.setText(string);
        }
        this.dialogArea.layout(true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doApply() {
        switch (this.alarmAction) {
            case 1: {
                try {
                    int t = Integer.parseInt(this.alarmTimeout.getText());
                    if (t < 0) {
                        Shell shell = this.getShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openWarning((Shell)shell, (String)Messages.RuleAlarm_Warning, (String)Messages.RuleAlarm_WarningInvalidTimeout);
                        return false;
                    }
                    this.rule.setAlarmTimeout(t);
                }
                catch (NumberFormatException e) {
                    Shell shell = this.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openWarning((Shell)shell, (String)Messages.RuleAlarm_Warning, (String)Messages.RuleAlarm_WarningInvalidTimeout);
                    return false;
                }
                this.rule.setAlarmMessage(this.alarmMessage.getText());
                this.rule.setAlarmKey(this.alarmKeyCreate.getText());
                this.rule.setAlarmSeverity(Severity.getByValue((int)this.alarmSeverity.getSelectionIndex()));
                this.rule.setAlarmTimeoutEvent(this.timeoutEvent.getEventCode());
                this.rule.setAlarmCategories(this.alarmCategory.getCategoryId());
                this.rule.setRcaScriptName(this.rcaScript.getScriptName());
                this.rule.setFlags(this.rule.getFlags() | 8);
                if (this.checkCreateHelpdeskTicket.getSelection()) {
                    this.rule.setFlags(this.rule.getFlags() | 0x2000);
                    break;
                }
                this.rule.setFlags(this.rule.getFlags() & 0xFFFFDFFF);
                break;
            }
            case 2: 
            case 3: {
                this.rule.setAlarmKey(this.alarmKeyTerminate.getText());
                this.rule.setAlarmSeverity(this.alarmAction == 3 ? Severity.TERMINATE : Severity.RESOLVE);
                this.rule.setFlags(this.rule.getFlags() | 8);
                if (this.checkTerminateWithRegexp.getSelection()) {
                    this.rule.setFlags(this.rule.getFlags() | 0x20);
                } else {
                    this.rule.setFlags(this.rule.getFlags() & 0xFFFFFFDF);
                }
                this.rule.setFlags(this.rule.getFlags() & 0xFFFFDFFF);
                break;
            }
            default: {
                this.rule.setFlags(this.rule.getFlags() & 0xFFFFDFF7);
            }
        }
        this.editor.setModified(true);
        return true;
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        return this.doApply();
    }
}

