/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.TransformationTestResult;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class TestTransformationDlg
extends Dialog {
    private static final int RUN = 111;
    private DataCollectionObject object;
    private String script;
    private LabeledText inputValue;
    private CLabel status;
    private LabeledText result;
    private Image imageWaiting;

    public TestTransformationDlg(Shell parentShell, DataCollectionObject object, String script) {
        super(parentShell);
        this.object = object;
        this.script = script;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Messages.get();
        Button b = this.createButton(parent, 111, Messages.TestTransformationDlg_Run, true);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestTransformationDlg.this.runScript();
            }
        });
        Messages.get();
        this.createButton(parent, 1, Messages.TestTransformationDlg_Close, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.imageWaiting = Activator.getImageDescriptor("icons/waiting.png").createImage();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TestTransformationDlg.this.imageWaiting.dispose();
            }
        });
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.inputValue = new LabeledText(dialogArea, 0);
        Messages.get();
        this.inputValue.setLabel(Messages.TestTransformationDlg_Input);
        GridData gd = new GridData();
        gd.widthHint = 300;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.inputValue.setLayoutData((Object)gd);
        this.status = new CLabel(dialogArea, 2048);
        this.status.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Messages.get();
        this.status.setText(Messages.TestTransformationDlg_Idle);
        this.status.setImage(StatusDisplayInfo.getStatusImage((ObjectStatus)ObjectStatus.UNKNOWN));
        this.result = new LabeledText(dialogArea, 0);
        Messages.get();
        this.result.setLabel(Messages.TestTransformationDlg_Result);
        this.result.getTextControl().setEditable(false);
        this.result.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return dialogArea;
    }

    private void runScript() {
        this.result.setText("");
        final NXCSession session = ConsoleSharedData.getSession();
        AbstractObject owner = session.findObjectById(this.object.getNodeId());
        if (owner == null || !(owner instanceof DataCollectionTarget)) {
            ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createDataCollectionTargetSelectionFilter());
            dlg.setTitle("Select Execution Target");
            if (dlg.open() != 0) {
                this.status.setText("Cancelled");
                this.status.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.MINOR));
                return;
            }
            owner = (AbstractObject)dlg.getSelectedObjects().get(0);
            if (owner == null || !(owner instanceof DataCollectionTarget)) {
                this.status.setText("Invalid execution target");
                this.status.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL));
                return;
            }
        }
        this.getButton(111).setEnabled(false);
        final String input = this.inputValue.getText();
        this.inputValue.getTextControl().setEditable(false);
        Messages.get();
        this.status.setText(Messages.TestTransformationDlg_Running);
        this.status.setImage(this.imageWaiting);
        final long nodeId = owner.getObjectId();
        Messages.get();
        new ConsoleJob(Messages.TestTransformationDlg_JobTitle, null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TransformationTestResult r = session.testTransformationScript(nodeId, TestTransformationDlg.this.script, input, TestTransformationDlg.this.object);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TestTransformationDlg.this.getShell() == null || TestTransformationDlg.this.getShell().isDisposed()) {
                            return;
                        }
                        if (r.success) {
                            CLabel cLabel = (this).TestTransformationDlg.this.status;
                            Messages.get();
                            cLabel.setText(Messages.TestTransformationDlg_Success);
                            (this).TestTransformationDlg.this.status.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.NORMAL));
                        } else {
                            CLabel cLabel = (this).TestTransformationDlg.this.status;
                            Messages.get();
                            cLabel.setText(Messages.TestTransformationDlg_Failure);
                            (this).TestTransformationDlg.this.status.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL));
                        }
                        (this).TestTransformationDlg.this.result.setText(r.result);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.TestTransformationDlg_JobError;
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TestTransformationDlg.this.getShell() == null || TestTransformationDlg.this.getShell().isDisposed()) {
                            return;
                        }
                        TestTransformationDlg.this.getButton(111).setEnabled(true);
                        (this).TestTransformationDlg.this.inputValue.getTextControl().setEditable(true);
                        (this).TestTransformationDlg.this.inputValue.getTextControl().setFocus();
                    }
                });
            }
        }.start();
    }
}

