/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.TimeFormatter;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.ChartLegend;
import org.netxms.nxmc.tools.ColorConverter;

public class ChartLegend
extends Composite {
    private static final int SYMBOL_WIDTH = 12;
    private static final int EXTENDED_LEGEND_DATA_SPACING = 6;
    private final Color defaultForeground = Display.getCurrent().getSystemColor(2);
    private Chart chart;
    private Label[] headerLabels = new Label[4];
    private Label[][] dataLabels = new Label[16][4];
    private Font headerFont = null;
    private boolean vertical;
    private MouseListener mouseListener;

    public ChartLegend(Chart chart, Color foreground, boolean vertical) {
        super((Composite)chart, 0);
        this.chart = chart;
        this.vertical = vertical;
        super.setBackground(chart.getBackground());
        super.setForeground(foreground);
        this.updateHeaderFont();
        this.addDisposeListener((DisposeListener & Serializable)e -> {
            if (this.headerFont != null) {
                this.headerFont.dispose();
            }
        });
        this.mouseListener = new /* Unavailable Anonymous Inner Class!! */;
        this.rebuild();
    }

    public void setForeground(Color color) {
        Color effectiveColor = color != null ? color : this.defaultForeground;
        super.setForeground(effectiveColor);
        this.updateChildren((Composite)this, c -> c.setForeground(effectiveColor));
    }

    public void setBackground(Color color) {
        Color effectiveColor = color != null ? color : this.chart.getBackground();
        super.setBackground(effectiveColor);
        this.updateChildren((Composite)this, c -> c.setBackground(effectiveColor));
    }

    private void updateChildren(Composite parent, Consumer<Control> operation) {
        for (Control c : parent.getChildren()) {
            operation.accept(c);
            if (!(c instanceof Composite)) continue;
            this.updateChildren((Composite)c, operation);
        }
    }

    private void updateHeaderFont() {
        if (this.headerFont != null) {
            this.headerFont.dispose();
        }
        FontData fd = this.getFont().getFontData()[0];
        fd.setStyle(1);
        this.headerFont = new Font((Device)this.getDisplay(), fd);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateHeaderFont();
        for (int i = 0; i < this.headerLabels.length; ++i) {
            if (this.headerLabels[i] == null) continue;
            this.headerLabels[i].setFont(this.headerFont);
        }
        this.chart.layout();
    }

    public void rebuild() {
        for (Control c : this.getChildren()) {
            c.dispose();
        }
        ChartConfiguration configuration = this.chart.getConfiguration();
        if (configuration == null) {
            return;
        }
        if (configuration.isExtendedLegend() && this.chart.getType() == ChartType.LINE) {
            layout = new GridLayout();
            layout.numColumns = 5;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
            this.setLayout((Layout)layout);
            new Label((Composite)this, 0);
            this.headerLabels[0] = new Label((Composite)this, 0);
            this.headerLabels[0].setText("Curr");
            this.headerLabels[0].setFont(this.headerFont);
            this.headerLabels[0].setBackground(this.getBackground());
            this.headerLabels[0].setForeground(this.getForeground());
            gd = new GridData();
            gd.horizontalIndent = 6;
            this.headerLabels[0].setLayoutData((Object)gd);
            this.headerLabels[1] = new Label((Composite)this, 0);
            this.headerLabels[1].setText("Min");
            this.headerLabels[1].setFont(this.headerFont);
            this.headerLabels[1].setBackground(this.getBackground());
            this.headerLabels[1].setForeground(this.getForeground());
            this.headerLabels[2] = new Label((Composite)this, 0);
            this.headerLabels[2].setText("Max");
            this.headerLabels[2].setFont(this.headerFont);
            this.headerLabels[2].setBackground(this.getBackground());
            this.headerLabels[2].setForeground(this.getForeground());
            this.headerLabels[3] = new Label((Composite)this, 0);
            this.headerLabels[3].setText("Avg");
            this.headerLabels[3].setFont(this.headerFont);
            this.headerLabels[3].setBackground(this.getBackground());
            this.headerLabels[3].setForeground(this.getForeground());
            metrics = this.chart.getItems();
            for (i = 0; i < metrics.size(); ++i) {
                color = ((ChartDciConfig)metrics.get(i)).getColorAsInt();
                new LegendLabel(this, (Composite)this, color != -1 ? ColorConverter.rgbFromInt((int)color) : this.chart.getPaletteEntry(i).getRGBObject(), ((ChartDciConfig)metrics.get(i)).getLabel());
                for (j = 0; j < 4; ++j) {
                    this.dataLabels[i][j] = new Label((Composite)this, 0);
                    this.dataLabels[i][j].setBackground(this.getBackground());
                    this.dataLabels[i][j].setForeground(this.getForeground());
                    if (j != 0) continue;
                    gd = new GridData();
                    gd.horizontalIndent = 6;
                    this.dataLabels[i][j].setLayoutData((Object)gd);
                }
            }
            this.refresh();
        } else if (configuration.isExtendedLegend() && (this.chart.getType() == ChartType.BAR || this.chart.getType() == ChartType.PIE)) {
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
            this.setLayout((Layout)layout);
            new Label((Composite)this, 0);
            this.headerLabels[0] = new Label((Composite)this, 0);
            this.headerLabels[0].setText("Value");
            this.headerLabels[0].setFont(this.headerFont);
            this.headerLabels[0].setBackground(this.getBackground());
            this.headerLabels[0].setForeground(this.getForeground());
            gd = new GridData();
            gd.horizontalIndent = 6;
            this.headerLabels[0].setLayoutData((Object)gd);
            this.headerLabels[1] = new Label((Composite)this, 0);
            this.headerLabels[1].setText("Pct");
            this.headerLabels[1].setFont(this.headerFont);
            this.headerLabels[1].setBackground(this.getBackground());
            this.headerLabels[1].setForeground(this.getForeground());
            metrics = this.chart.getItems();
            for (i = 0; i < metrics.size(); ++i) {
                color = ((ChartDciConfig)metrics.get(i)).getColorAsInt();
                new LegendLabel(this, (Composite)this, color != -1 ? ColorConverter.rgbFromInt((int)color) : this.chart.getPaletteEntry(i).getRGBObject(), ((ChartDciConfig)metrics.get(i)).getLabel());
                for (j = 0; j < 2; ++j) {
                    this.dataLabels[i][j] = new Label((Composite)this, 0);
                    this.dataLabels[i][j].setBackground(this.getBackground());
                    this.dataLabels[i][j].setForeground(this.getForeground());
                    if (j != 0) continue;
                    gd = new GridData();
                    gd.horizontalIndent = 6;
                    this.dataLabels[i][j].setLayoutData((Object)gd);
                }
            }
            this.refresh();
        } else {
            layout = new RowLayout(this.vertical ? 512 : 256);
            layout.pack = false;
            layout.marginBottom = 0;
            layout.marginTop = 0;
            layout.marginLeft = 0;
            layout.marginRight = 0;
            this.setLayout((Layout)layout);
            List metrics = this.chart.getItems();
            for (int i = 0; i < metrics.size(); ++i) {
                int color = ((ChartDciConfig)metrics.get(i)).getColorAsInt();
                new LegendLabel(this, (Composite)this, color != -1 ? ColorConverter.rgbFromInt((int)color) : this.chart.getPaletteEntry(i).getRGBObject(), ((ChartDciConfig)metrics.get(i)).getLabel());
            }
        }
        for (Control c : this.getChildren()) {
            c.addMouseListener(this.mouseListener);
        }
    }

    public void refresh() {
        boolean useMultipliers = this.chart.getConfiguration().isUseMultipliers();
        double total = 0.0;
        if (this.chart.getType() == ChartType.BAR || this.chart.getType() == ChartType.PIE) {
            for (DataSeries s : this.chart.getDataSeries()) {
                total += s.getCurrentValue();
            }
        }
        int row = 0;
        for (DataSeries s : this.chart.getDataSeries()) {
            ChartDciConfig item = this.chart.getItem(row);
            String format = item.getDisplayFormat() == null || item.getDisplayFormat().isEmpty() ? (useMultipliers ? "%{m,u}.3f" : "%{u}.3f") : item.getDisplayFormat();
            DataFormatter formatter = new DataFormatter(format, DataType.FLOAT, item.measurementUnit);
            TimeFormatter timeFormatter = DateFormatFactory.getTimeFormatter();
            this.dataLabels[row][0].setText(formatter.format(s.getCurrentValueAsString(), timeFormatter));
            if (this.chart.getType() == ChartType.LINE) {
                this.dataLabels[row][1].setText(formatter.format(Double.toString(s.getMinValue()), timeFormatter));
                this.dataLabels[row][2].setText(formatter.format(Double.toString(s.getMaxValue()), timeFormatter));
                this.dataLabels[row][3].setText(formatter.format(Double.toString(s.getAverageValue()), timeFormatter));
            } else {
                this.dataLabels[row][1].setText(String.format("%.2f%%", total > 0.0 ? s.getCurrentValue() / total * 100.0 : 0.0));
            }
            ++row;
        }
        this.chart.layout();
    }
}

