/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.preferencepages;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.preferencepages.RegionalSettingsPage;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class RegionalSettingsPage
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(RegionalSettingsPage.class);
    private Combo dateTimeFormat;
    private LabeledText dateFormatString;
    private LabeledText timeFormatString;
    private LabeledText shortTimeFormatString;
    private LabeledText dateTimeExample;
    private LabeledText shortTimeExample;
    private Button checkServerTimeZone;
    private int format;

    public RegionalSettingsPage() {
        super(LocalizationHelper.getI18n(RegionalSettingsPage.class).tr("Regional Settings"));
        this.setPreferenceStore((IPreferenceStore)PreferenceStore.getInstance());
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.dateTimeFormat = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Date and time format"), (Object)gd);
        this.dateTimeFormat.add(this.i18n.tr("Defined by server"));
        this.dateTimeFormat.add(this.i18n.tr("JVM default locale"));
        this.dateTimeFormat.add(this.i18n.tr("Custom"));
        this.format = this.getPreferenceStore().getInt("DateFormatFactory.Format.DateTime");
        this.dateTimeFormat.select(this.format);
        this.dateTimeFormat.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        2 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.dateFormatString = new LabeledText(dialogArea, 0);
        this.dateFormatString.setLabel(this.i18n.tr("Date format string"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dateFormatString.setLayoutData((Object)gd);
        this.dateFormatString.setText(this.getPreferenceStore().getString("DateFormatFactory.Format.Date"));
        this.dateFormatString.setEnabled(this.format == 2);
        this.dateFormatString.getTextControl().addModifyListener((ModifyListener)listener);
        this.timeFormatString = new LabeledText(dialogArea, 0);
        this.timeFormatString.setLabel(this.i18n.tr("Time format string"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timeFormatString.setLayoutData((Object)gd);
        this.timeFormatString.setText(this.getPreferenceStore().getString("DateFormatFactory.Format.Time"));
        this.timeFormatString.setEnabled(this.format == 2);
        this.timeFormatString.getTextControl().addModifyListener((ModifyListener)listener);
        this.shortTimeFormatString = new LabeledText(dialogArea, 0);
        this.shortTimeFormatString.setLabel(this.i18n.tr("Short time format string"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.shortTimeFormatString.setLayoutData((Object)gd);
        this.shortTimeFormatString.setText(this.getPreferenceStore().getString("DateFormatFactory.Format.ShortTime"));
        this.shortTimeFormatString.setEnabled(this.format == 2);
        this.shortTimeFormatString.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dateTimeExample = new LabeledText(dialogArea, 0, 2056);
        this.dateTimeExample.setLabel(this.i18n.tr("Date and time formatting example"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.dateTimeExample.setLayoutData((Object)gd);
        this.shortTimeExample = new LabeledText(dialogArea, 0, 2056);
        this.shortTimeExample.setLabel(this.i18n.tr("Short time example"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.shortTimeExample.setLayoutData((Object)gd);
        this.checkServerTimeZone = new Button(dialogArea, 32);
        this.checkServerTimeZone.setText(this.i18n.tr("Use server time &zone"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        this.checkServerTimeZone.setLayoutData((Object)gd);
        this.checkServerTimeZone.setSelection(this.getPreferenceStore().getBoolean("DateFormatFactory.UseServerTimeZone"));
        this.updateExample(null);
        this.updateShortTimeExample(null);
        return dialogArea;
    }

    private void updateExample(Control updatedControl) {
        DateFormat df;
        switch (this.format) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getDateFormat() + " " + session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(this.dateFormatString.getText() + " " + this.timeFormatString.getText());
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.setErrorMessage(e.getLocalizedMessage());
                    if (updatedControl != null) {
                        updatedControl.setBackground(ThemeEngine.getBackgroundColor((String)"TextInput.Error"));
                    }
                    return;
                }
            }
            default: {
                df = DateFormat.getDateTimeInstance(3, 2);
            }
        }
        this.dateTimeExample.setText(df.format(new Date(System.currentTimeMillis())));
        this.setErrorMessage(null);
        this.dateFormatString.getTextControl().setBackground(null);
        this.timeFormatString.getTextControl().setBackground(null);
    }

    private void updateShortTimeExample(Control updatedControl) {
        DateFormat df;
        switch (this.format) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getShortTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(this.shortTimeFormatString.getText());
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.setErrorMessage(e.getLocalizedMessage());
                    if (updatedControl != null) {
                        updatedControl.setBackground(ThemeEngine.getBackgroundColor((String)"TextInput.Error"));
                    }
                    return;
                }
            }
            default: {
                df = DateFormat.getTimeInstance(3);
            }
        }
        this.shortTimeExample.setText(df.format(new Date(System.currentTimeMillis())));
        this.setErrorMessage(null);
        this.shortTimeFormatString.getTextControl().setBackground(null);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.format = this.getPreferenceStore().getInt("DateFormatFactory.Format.DateTime");
        this.dateTimeFormat.select(this.format);
        this.dateFormatString.setText(this.getPreferenceStore().getString("DateFormatFactory.Format.Date"));
        this.timeFormatString.setText(this.getPreferenceStore().getString("DateFormatFactory.Format.Time"));
        this.shortTimeFormatString.setText(this.getPreferenceStore().getString("DateFormatFactory.Format.ShortTime"));
        this.dateFormatString.setEnabled(this.format == 2);
        this.timeFormatString.setEnabled(this.format == 2);
        this.shortTimeFormatString.setEnabled(this.format == 2);
        this.checkServerTimeZone.setSelection(false);
        this.updateExample(null);
    }

    protected boolean applyChanges(boolean isApply) {
        IPreferenceStore ps = this.getPreferenceStore();
        ps.setValue("DateFormatFactory.Format.DateTime", this.format);
        ps.setValue("DateFormatFactory.Format.Date", this.dateFormatString.getText());
        ps.setValue("DateFormatFactory.Format.Time", this.timeFormatString.getText());
        ps.setValue("DateFormatFactory.Format.ShortTime", this.shortTimeFormatString.getText());
        ps.setValue("DateFormatFactory.UseServerTimeZone", this.checkServerTimeZone.getSelection());
        DateFormatFactory.updateFromPreferences();
        return true;
    }
}

