/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RadioInterfaceComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        RadioInterface rif1 = (RadioInterface)e1;
        RadioInterface rif2 = (RadioInterface)e2;
        int result = switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 1 -> ((AccessPoint)rif1.getOwner()).getMacAddress().compareTo(((AccessPoint)rif2.getOwner()).getMacAddress());
            case 3 -> ((AccessPoint)rif1.getOwner()).getModel().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getModel());
            case 0 -> ((AccessPoint)rif1.getOwner()).getObjectName().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getObjectName());
            case 4 -> ((AccessPoint)rif1.getOwner()).getSerialNumber().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getSerialNumber());
            case 2 -> ((AccessPoint)rif1.getOwner()).getVendor().compareToIgnoreCase(((AccessPoint)rif2.getOwner()).getVendor());
            case 9 -> rif1.getChannel() - rif2.getChannel();
            case 5 -> rif1.getIndex() - rif2.getIndex();
            case 7 -> rif1.getBSSID().compareTo(rif2.getBSSID());
            case 8 -> this.getVendorByMAC(rif1.getBSSID()).compareToIgnoreCase(this.getVendorByMAC(rif2.getBSSID()));
            case 6 -> rif1.getName().compareToIgnoreCase(rif2.getName());
            case 10 -> rif1.getPowerDBm() - rif2.getPowerDBm();
            case 11 -> rif1.getPowerMW() - rif2.getPowerMW();
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendorByMAC(MacAddress macAddr) {
        String vendor = this.session.getVendorByMac(macAddr, null);
        return vendor != null ? vendor : "";
    }
}

