/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class Polyline
extends AbstractPointListShape {
    private int tolerance = 2;
    private static final Rectangle LINEBOUNDS = Rectangle.SINGLETON;

    public Polyline() {
        this.setFill(false);
        this.bounds = null;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        int tolerance = (int)Math.max(this.getLineWidthFloat() / 2.0f, (float)this.tolerance);
        LINEBOUNDS.setBounds(this.getBounds());
        LINEBOUNDS.expand(tolerance, tolerance);
        if (!LINEBOUNDS.contains(x, y)) {
            return false;
        }
        return this.shapeContainsPoint(x, y) || this.childrenContainsPoint(x, y);
    }

    @Override
    protected boolean shapeContainsPoint(int x, int y) {
        return Geometry.polylineContainsPoint(this.points, x, y, this.tolerance);
    }

    @Override
    protected void fillShape(Graphics g) {
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            int expand = (int)(this.getLineWidthFloat() / 2.0f);
            this.bounds = this.getPoints().getBounds().getExpanded(expand, expand);
        }
        return this.bounds;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    protected void outlineShape(Graphics g) {
        g.drawPolyline(this.points);
    }

    @Override
    public void primTranslate(int x, int y) {
    }

    @Override
    public void removeAllPoints() {
        super.removeAllPoints();
        this.bounds = null;
    }

    @Override
    public void setLineWidth(int w) {
        if (this.getLineWidthFloat() == (float)w) {
            return;
        }
        if ((float)w < this.getLineWidthFloat()) {
            this.erase();
        }
        this.bounds = null;
        super.setLineWidthFloat(w);
    }

    @Override
    public void setPoints(PointList points) {
        super.setPoints(points);
        this.firePropertyChange("points", null, points);
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public void repaint() {
        this.bounds = null;
        super.repaint();
    }
}

