/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.SourceProvider;

public class SummaryTablesCache {
    private static SummaryTablesCache instance = null;
    private Map<Integer, DciSummaryTableDescriptor> tables = new HashMap<Integer, DciSummaryTableDescriptor>();
    private NXCSession session;

    public static void attachSession(NXCSession session) {
        instance = new SummaryTablesCache(session);
        Activator.logInfo("Instance of summary tables cache created");
    }

    public static SummaryTablesCache getInstance() {
        return instance;
    }

    private SummaryTablesCache(NXCSession session) {
        this.session = session;
        this.reload();
        session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1021: {
                        SummaryTablesCache.this.onTableChange((int)n.getSubCode());
                        break;
                    }
                    case 1022: {
                        SummaryTablesCache.this.onTableDelete((int)n.getSubCode());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            List list = this.session.listDciSummaryTables();
            Map<Integer, DciSummaryTableDescriptor> map = this.tables;
            synchronized (map) {
                this.tables.clear();
                for (DciSummaryTableDescriptor d : list) {
                    this.tables.put(d.getId(), d);
                }
                Activator.logInfo(String.valueOf(this.tables.size()) + " summary tables registered");
            }
            SourceProvider.getInstance().update();
        }
        catch (Exception e) {
            Activator.logError("Exception in SummaryTablesCache.reload()", e);
        }
    }

    private void onTableChange(int tableId) {
        new Thread(){

            @Override
            public void run() {
                SummaryTablesCache.this.reload();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTableDelete(int tableId) {
        Map<Integer, DciSummaryTableDescriptor> map = this.tables;
        synchronized (map) {
            this.tables.remove(tableId);
        }
        SourceProvider.getInstance().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DciSummaryTableDescriptor[] getTables() {
        Map<Integer, DciSummaryTableDescriptor> map = this.tables;
        synchronized (map) {
            return this.tables.values().toArray(new DciSummaryTableDescriptor[this.tables.values().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmpty(boolean menuOnly) {
        Map<Integer, DciSummaryTableDescriptor> map = this.tables;
        synchronized (map) {
            DciSummaryTableDescriptor d;
            if (!menuOnly) {
                return this.tables.isEmpty();
            }
            Iterator<DciSummaryTableDescriptor> iterator = this.tables.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((d = iterator.next()).getMenuPath().isEmpty());
            return false;
        }
    }
}

