/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.console.ViewerElementUpdater;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RadioInterfaceLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private TableViewer viewer;
    private NXCSession session = ConsoleSharedData.getSession();

    public RadioInterfaceLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        RadioInterface rif = (RadioInterface)element;
        switch (columnIndex) {
            case 1: {
                return ((AccessPoint)rif.getOwner()).getMacAddress().toString();
            }
            case 3: {
                return ((AccessPoint)rif.getOwner()).getModel();
            }
            case 0: {
                return ((AccessPoint)rif.getOwner()).getObjectName();
            }
            case 4: {
                return ((AccessPoint)rif.getOwner()).getSerialNumber();
            }
            case 2: {
                return ((AccessPoint)rif.getOwner()).getVendor();
            }
            case 9: {
                return Integer.toString(rif.getChannel());
            }
            case 5: {
                return Integer.toString(rif.getIndex());
            }
            case 7: {
                return rif.getBSSID().toString();
            }
            case 8: {
                return this.session.getVendorByMac(rif.getBSSID(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
            }
            case 6: {
                return rif.getName();
            }
            case 10: {
                return Integer.toString(rif.getPowerDBm());
            }
            case 11: {
                return Integer.toString(rif.getPowerMW());
            }
        }
        return null;
    }
}

