/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.DeviceBackupJobStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.DeviceBackup;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.xnap.commons.i18n.I18n;

public class DeviceBackup
extends TableElement {
    private final I18n i18n = LocalizationHelper.getI18n(DeviceBackup.class);
    private boolean enabled = Registry.getSession().isServerComponentRegistered("DEVBACKUP");

    public DeviceBackup(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected String getTitle() {
        return this.i18n.tr("Device Backup");
    }

    protected void fillTable() {
        if (!(this.getObject() instanceof AbstractNode)) {
            return;
        }
        AbstractNode node = (AbstractNode)this.getObject();
        this.addPair(this.i18n.tr("Registered"), node.isRegisteredForConfigBackup() ? this.i18n.tr("Yes") : this.i18n.tr("No"));
        this.addPair(this.i18n.tr("Last job status"), this.jobStatusToText(node.getLastConfigBackupJobStatus()));
    }

    private String jobStatusToText(DeviceBackupJobStatus status) {
        switch (1.$SwitchMap$org$netxms$client$constants$DeviceBackupJobStatus[status.ordinal()]) {
            case 1: {
                return this.i18n.tr("Failed");
            }
            case 2: {
                return this.i18n.tr("Successful");
            }
        }
        return this.i18n.tr("Unknown");
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return this.enabled && object instanceof AbstractNode;
    }
}

