/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.businessservice.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.businessservice.propertypages.InstanceDiscovery;
import org.netxms.nxmc.tools.ObjectNameValidator;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateBusinessServicePrototype
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(CreateBusinessServicePrototype.class);
    private LabeledText nameField;
    private LabeledText aliasField;
    private Combo instanceDiscoveyMethodCombo;
    private String name;
    private String alias;
    private String instanceDiscoveyMethod;

    public CreateBusinessServicePrototype(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Business Service Prototype"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel(this.i18n.tr("Name"));
        this.nameField.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel(this.i18n.tr("Alias"));
        this.aliasField.getTextControl().setTextLimit(63);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.aliasField.setLayoutData((Object)gd);
        this.instanceDiscoveyMethodCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Instance discovery type"), (Object)new GridData(4, 0x1000000, true, false));
        for (String type : InstanceDiscovery.DISCOVERY_TYPES) {
            if (type == null) continue;
            this.instanceDiscoveyMethodCombo.add(type);
        }
        this.instanceDiscoveyMethodCombo.select(0);
        return dialogArea;
    }

    protected void okPressed() {
        if (!WidgetHelper.validateTextInput((LabeledText)this.nameField, (TextFieldValidator)new ObjectNameValidator())) {
            WidgetHelper.adjustWindowSize((Window)this);
            return;
        }
        this.instanceDiscoveyMethod = this.instanceDiscoveyMethodCombo.getText();
        this.alias = this.aliasField.getText().trim();
        this.name = this.nameField.getText().trim();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getInstanceDiscoveyMethod() {
        return InstanceDiscovery.DISCOVERY_TYPES.indexOf(this.instanceDiscoveyMethod);
    }
}

