/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.MessageArea;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class MessageArea
extends Canvas
implements MessageAreaHolder {
    private final I18n i18n = LocalizationHelper.getI18n(MessageArea.class);
    public static final int INFORMATION = 0;
    public static final int SUCCESS = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    private static final int MARGIN_WIDTH = 4;
    private static final int MARGIN_HEIGHT = 4;
    private static final int MESSAGE_SPACING = 4;
    private static final int TEXT_MARGIN_WIDTH = 5;
    private static final int TEXT_MARGIN_HEIGHT = 5;
    private static Image[] icons = null;
    private static Image iconClose = null;
    private static Image iconShowAll = null;
    private int nextMessageId = 1;
    private List<Message> messages = new ArrayList(0);
    private long messageTimeout = 20000L;
    private Runnable timer = null;
    private ImageHyperlink buttonShowAll = null;
    private Shell popupListShell = null;

    public MessageArea(Composite parent, int style) {
        super(parent, style);
        if (icons == null) {
            icons = new Image[4];
            MessageArea.icons[0] = ResourceManager.getImage((String)"icons/messages/info.png");
            MessageArea.icons[1] = ResourceManager.getImage((String)"icons/messages/success.png");
            MessageArea.icons[2] = ResourceManager.getImage((String)"icons/messages/warning.png");
            MessageArea.icons[3] = ResourceManager.getImage((String)"icons/messages/error.png");
            iconClose = ResourceManager.getImage((String)"icons/messages/close.png");
            iconShowAll = ResourceManager.getImage((String)"icons/messages/show-all.png");
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
    }

    public int addMessage(int level, String text) {
        return this.addMessage(level, text, false);
    }

    public int addMessage(int level, String text, boolean sticky) {
        return this.addMessage(level, text, sticky, null, null);
    }

    public int addMessage(int level, String text, boolean sticky, String buttonText, Runnable action) {
        if (this.isDisposed()) {
            return -1;
        }
        Message m = new Message(this.nextMessageId++, level, text, sticky, buttonText, action);
        if (!this.messages.isEmpty()) {
            ((Message)this.messages.get(0)).disposeControl();
        }
        this.messages.add(0, m);
        m.control = new MessageComposite(this, (Composite)this, m, mc -> this.deleteMessage(m.id));
        m.control.moveAbove(null);
        m.control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.buttonShowAll == null) {
            this.buttonShowAll = new ImageHyperlink((Composite)this, 0);
            this.buttonShowAll.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.buttonShowAll.setImage(iconShowAll);
            this.buttonShowAll.setToolTipText(this.i18n.tr("Show all notifications"));
            this.buttonShowAll.setText("(1)");
            this.buttonShowAll.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.buttonShowAll.setText("(" + Integer.toString(this.messages.size()) + ")");
        }
        if (this.timer == null) {
            this.timer = () -> this.onTimer();
            this.getDisplay().timerExec(1000, this.timer);
        }
        this.getParent().layout(true, true);
        return m.id;
    }

    public void deleteMessage(int id) {
        if (id < 1) {
            return;
        }
        for (int i = 0; i < this.messages.size(); ++i) {
            Message m = (Message)this.messages.get(i);
            if (m.id != id) continue;
            this.messages.remove(i);
            if (m.disposeControl() && !this.messages.isEmpty()) {
                m = (Message)this.messages.get(0);
                m.control = new MessageComposite(this, (Composite)this, m, mc -> this.deleteMessage(mc.message.id));
                m.control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                m.control.moveAbove(null);
            }
            if (this.messages.isEmpty() && this.buttonShowAll != null) {
                this.buttonShowAll.dispose();
                this.buttonShowAll = null;
            }
            if (!this.messages.isEmpty()) {
                this.buttonShowAll.setText("(" + Integer.toString(this.messages.size()) + ")");
            }
            this.getParent().layout(true, true);
            break;
        }
    }

    public void clearMessages() {
        if (this.messages.isEmpty()) {
            return;
        }
        for (Message m : this.messages) {
            m.disposeControl();
        }
        this.messages.clear();
        if (this.buttonShowAll != null) {
            this.buttonShowAll.dispose();
            this.buttonShowAll = null;
        }
        this.getParent().layout(true, true);
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    private void onTimer() {
        if (this.isDisposed()) {
            return;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.messages.size(); ++i) {
            Message m = (Message)this.messages.get(i);
            if (m.sticky || m.timestamp + this.messageTimeout >= now) continue;
            this.deleteMessage(m.id);
            --i;
        }
        if (!this.messages.isEmpty()) {
            this.getDisplay().timerExec(1000, this.timer);
        } else {
            this.timer = null;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.messages.isEmpty() ? new Point(0, 0) : super.computeSize(wHint, hHint, changed);
    }

    private void showAllMessages() {
        if (this.popupListShell != null) {
            this.popupListShell.close();
            this.popupListShell = null;
        }
        Rectangle bounds = this.buttonShowAll.getBounds();
        Point p = this.toDisplay(new Point(bounds.x + bounds.width, bounds.y + bounds.height + 2));
        this.popupListShell = new Shell(this.getDisplay(), 16388);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        layout.verticalSpacing = 4;
        this.popupListShell.setLayout((Layout)layout);
        int count = 0;
        for (Message m : this.messages) {
            if (count++ == 10 && this.messages.size() > 11) {
                int r = this.messages.size() - 10;
                new Label((Composite)this.popupListShell, 0).setText(this.i18n.tr("{0} more messages", (Object)r));
                break;
            }
            MessageComposite messageComposite = new MessageComposite(this, (Composite)this.popupListShell, m, mc -> {
                this.deleteMessage(m.id);
                mc.dispose();
                if (this.popupListShell.getChildren().length > 0) {
                    this.popupListShell.pack();
                    this.popupListShell.setLocation(p.x - this.popupListShell.getBounds().width, p.y);
                    this.popupListShell.forceFocus();
                } else {
                    this.popupListShell.close();
                    this.popupListShell = null;
                }
            });
            messageComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        this.popupListShell.addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.popupListShell.addListener(27, (Listener & Serializable)event -> {
            this.popupListShell.close();
            this.popupListShell = null;
        });
        this.popupListShell.pack();
        this.popupListShell.open();
        this.popupListShell.setLocation(p.x - this.popupListShell.getBounds().width, p.y);
        this.popupListShell.forceFocus();
    }
}

